(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Field.i3                                              *)
(* Last Modified On Thu Aug 22 00:48:58 1991 By kalsow         *)

INTERFACE Field;

IMPORT Type, String, Value, Expr;

PROCEDURE New (name: String.T;  offset: INTEGER;
                 type: Type.T;  dfault: Expr.T): Value.T;

PROCEDURE SetOffset (field: Value.T;  newOffset: INTEGER);

PROCEDURE Split (field   : Value.T;
             VAR offset  : INTEGER;
	     VAR type    : Type.T): BOOLEAN;

PROCEDURE SplitX (field   : Value.T;
              VAR offset  : INTEGER;
              VAR type    : Type.T);
(* =>  b := Split (field, offset, type, dfault); <* ASSERT b *> *)

PROCEDURE GetDefault (field: Value.T): Expr.T;

PROCEDURE EmitDeclaration (field: Value.T);
(* emit the C struct member or bit-field for 'field' *)

PROCEDURE IsEqual (va, vb: Value.T;  x: Type.Assumption): BOOLEAN;

END Field.
