(* Copyright (C) 1989, 1990, Digital Equipment Corporation     *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Ctypes.i3                                             *)
(* Last modified on Tue Sep  1 10:48:09 PDT 1992 by rustan         *)
(*      modified on Fri Feb  9 07:20:51 1990 by muller         *)
(*      modified on Wed Feb  7 15:49:32 1990 by jerome         *)

INTERFACE Ctypes;


(* The Modula3 Type' Style *)

TYPE

(************** KRML
  Double                     =  LONGREAL;
  DoubleStar                 =  UNTRACED REF Double;
************ KRML *)

  Char                       =  [-16_80 .. 16_7F];
  CharStar                   =  ADDRESS; (* in principle UNTRACED REF Char;
					    but it's so often used instead
					    of VoidStar .... *)
  CharStarStar               =  UNTRACED REF CharStar;
(************** KRML
  CharStarStarStar           =  UNTRACED REF CharStarStar;
************ KRML *)
  UnsignedChar               =  [16_0 .. 16_FF];
(************** KRML
  UnsignedCharStar           =  UNTRACED REF UnsignedChar;
  UnsignedCharStarStar       =  UNTRACED REF UnsignedCharStar;
************ KRML *)
  ConstCharStar              =  CharStar;
  ConstCharStarStar          =  CharStarStar;
(************** KRML
  ConstUnsignedCharStar      =  UnsignedCharStar;
************ KRML *)

(************** KRML
  Float                      =  REAL;
  FloatStar                  =  UNTRACED REF Float;
  LongFloat                  =  Double;
************ KRML *)

  Int                        =  INTEGER;
(************** KRML
  IntStar                    =  UNTRACED REF Int;
  IntStarStar                =  UNTRACED REF IntStar;
************ KRML *)
  UnsignedInt                =  INTEGER;
(************** KRML
  UnsignedIntStar            =  UNTRACED REF UnsignedInt;  
************ KRML *)

  Long                       =  INTEGER;
(************** KRML
  LongStar                   =  UNTRACED REF Long;
  LongStarStar               =  UNTRACED REF LongStar;
************ KRML *)
  UnsignedLong               =  INTEGER;
(************** KRML
  UnsignedLongStar           =  UNTRACED REF UnsignedLong;
************ KRML *)

  Short                      =  [-16_8000 .. 16_7FFF];
(************** KRML
  ShortStar                  =  UNTRACED REF Short;
  ShortStarStar              =  UNTRACED REF ShortStar;
************ KRML *)
  UnsignedShort              =  [16_0 .. 16_FFFF];
(************** KRML
  UnsignedShortStar          =  UNTRACED REF UnsignedShort;  
************ KRML *)

  Void                       =  ADDRESS;
  VoidStar                   =  ADDRESS;
  ConstVoidStar              =  ADDRESS;

(************** KRML
  String4                    = UNTRACED REF ARRAY [0..3] OF CHAR;
  String16                   = UNTRACED REF ARRAY [0..15] OF CHAR;
  String64                   = UNTRACED REF ARRAY [0..63] OF CHAR;
  String256                  = UNTRACED REF ARRAY [0..255] OF CHAR;
  String1024                 = UNTRACED REF ARRAY [0..1023] OF CHAR;
  String4096                 = UNTRACED REF ARRAY [0..4095] OF CHAR;
************ KRML *)


(* The C Type's Style *)


TYPE

(************** KRML
  double                     =  Double;
  double_star                =  DoubleStar;
************ KRML *)

  char                       =  Char;
  char_star                  =  CharStar;
  char_star_star             =  CharStarStar;
(************** KRML
  char_star_star_star        =  CharStarStarStar;
************ KRML *)
  unsigned_char              =  UnsignedChar;
(************** KRML
  unsigned_char_star         =  UnsignedCharStar;
  unsigned_char_star_star    =  UnsignedCharStarStar;
************ KRML *)
  const_char_star            =  ConstCharStar;
(************** KRML
  const_unsigned_char_star   =  ConstUnsignedCharStar;
************ KRML *)

(************** KRML
  float                      =  Float;
  float_star                 =  FloatStar;
  long_float                 =  Double;
************ KRML *)

  int                        =  Int;
(************** KRML
  int_star                   =  IntStar;
  int_star_star              =  IntStarStar;
************ KRML *)
  unsigned_int               =  UnsignedInt;
(************** KRML
  unsigned_int_star          =  UnsignedIntStar;
************ KRML *)

  long                       =  Long;
(************** KRML
  long_star                  =  LongStar;
  long_star_star             =  LongStarStar;
************ KRML *)
  unsigned_long              =  UnsignedLong;
(************** KRML
  unsigned_long_star         =  UnsignedLongStar;
************ KRML *)

  short                      =  Short;
(************** KRML
  short_star                 =  ShortStar;
  short_star_star            =  ShortStarStar;
************ KRML *)
  unsigned_short             =  UnsignedShort;
(************** KRML
  unsigned_short_star        =  UnsignedShortStar;
************ KRML *)

  void                       =  Void;
  void_star                  =  VoidStar;
  const_void_star            =  ConstVoidStar;

(************** KRML
  string_4                   =  String4;
  string_16                  =  String16;
  string_64                  =  String64;
  string_256                 =  String256;
  string_1024                =  String1024;
  string_4096                =  String4096;
************ KRML *)


END Ctypes.
