/* Copyright (C) 1992, Digital Equipment Corporation    */
/* All rights reserved.                                 */
/* See the file COPYRIGHT for a full description.       */

/* cruntime.c                                           */
/* Last modified on     Sep 15 21:19:07 1992 by rustan  */

/* cruntime.c */
/* Rustan Leino */
/* 15 September 1992 */
/* This file and the associated assembly file provide the C run-time
   that is needed to compile Modula-3 programs for the Mosaic */


/* The 'n' parameter to the following functions refer to the number
 * of characters
 */
char * memcpy( char * t,  const char * s,  int n );
char * memmove( char * t,  const char * s,  int n );
void bzero( char * t,  int n );

void to_host( int code, int data );
void char_to_host( char c );
void int_to_host( int x );
void hex_to_host( int x );


/*-----  implementations  -----*/

char * memcpy( char * t,  const char * s,  int n )
{
  char * T = t;
  while ( n > 0 )
  {
    *(t++) = *(s++);
    n--;
  }
  return T;
}

char * memmove( char * t, const char * s, int n )
{
  char * T = t;
  if ( n > 0 && s != t )
  {
    if ( s < t )
    {
      s += n;  t += n;
      while ( n > 0 )
      {
	*(--t) = *(--s);
	n--;
      }
    }
    else  /* t < s */
    {
      while ( n > 0 )
      {
	*(t++) = *(s++);
	n--;
      }
    }
  }
  return T;
}  /* memmove */

void bzero( char * b, int length )
{
  while ( length > 0 )
  {
    *(b++) = 0;
    length--;
  }
}  /* bzero */


#ifdef OLD_STUFF
#define TOHOST_DATA (*(volatile int *)0x7ff8)
#define TOHOST_CODE (*(volatile int *)0x7ff7)
#define TOHOST_PID  (*(volatile int *)0x7ff6)

/* Note, the caller needs to ensure that this function is not called
 * concurrently
 */
void to_host( int code, int data )
{
  TOHOST_PID = 0;
  TOHOST_DATA = data;
  TOHOST_CODE = code;
  while ( TOHOST_CODE != 0 )
    ;
}

#define CODE_PRINT_CHAR			2
#define CODE_PRINT_INT			3
#define CODE_PRINT_HEX			4


void char_to_host( char c )
{
  to_host( CODE_PRINT_CHAR, c );
}

void int_to_host( int x )
{
  to_host( CODE_PRINT_INT, x );
}

void hex_to_host( int x )
{
  to_host( CODE_PRINT_HEX, x );
}

#endif  /* OLD_STUFF */

/* end of cruntime.c */
