(* new interface KRML *)
UNSAFE INTERFACE RTMemory;
(* this interface is unsafe because it reveals MEMORY_Start and MEMORY_End,
   whose inproper modification may havoc the run-time *)

VAR
  MEMORY_Start: ADDRESS := NIL;
  MEMORY_End: ADDRESS := NIL;

CONST
  (* There are BytesPerAddr  bytes             per addressable unit
               AddrPerAlign  addressable units per alignment
               BytesPerAlign bytes             per alignment *)
  (* AddrPerAlign satisfies, for any address a:
       ( INT(a) MOD AddrPerAlign = 0 ) = ( any object can start at address a )
     where INT(a) means LOOPHOLE( a, INTEGER ).  
     NOTE.  Changing this value will also require a change in M3Runtime.h.
     (See comment on RefHeader and Header in RTHeapKRML.m3.) *)
  AddrPerAlign = 8;
  BytesPerAddr = 1;

PROCEDURE Init();
(* sets up the MEMORY_Start and MEMORY_End pointers;
   called by RTHeap.InitHeap() before MEMORY_Start and MEMORY_End are used *)

END RTMemory.
