(* new module KRML *)
UNSAFE MODULE RTRegisters;

IMPORT Csetjmp;

PROCEDURE SetStackPointer( VAR regs: T; sp: ADDRESS ) =
  BEGIN
    LOOPHOLE( regs[ Csetjmp.SP_index ], ADDRESS ) := sp
  END SetStackPointer;

PROCEDURE GetStackPointer( READONLY regs: T ): ADDRESS =
  BEGIN
    RETURN LOOPHOLE( regs[ Csetjmp.SP_index ], ADDRESS )
  END GetStackPointer;

PROCEDURE FlushStackCache() =
  (* flush any part of the stack cached in registers *)
  VAR regs: T;
  BEGIN
    IF Save( regs ) = 0 THEN
      Restore( regs )
    END
  END FlushStackCache;

BEGIN
END RTRegisters.
