(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

(* new interface KRML *)
INTERFACE RTRegisters;

IMPORT Word;

(* Note, as is stated in RTMain.i3, this run-time assumes that
   a variable of type T need no initialization before it is passed
   to Save, and that both Save and Restore can be called before
   this interface and module have been initialized. *)

TYPE
  T = ARRAY [0..7] OF Word.T;

<* EXTERNAL "newjmpbuf" *>
PROCEDURE New( VAR regs: T; stackHigh: ADDRESS; pc: PROCEDURE());

<* EXTERNAL "setjmp" *>  PROCEDURE Save( VAR regs: T ): INTEGER;
<* EXTERNAL "longjmp" *> PROCEDURE Restore( VAR regs: T );

<* EXTERNAL "RTRegisters__SaveOtherSequence" *>
PROCEDURE SaveOtherSequence( VAR regs: T );
(* Note, the registers saved in this call have a different format from
   those saved in setjmp.  The buffers returned from these two calls
   are NOT compatible! *)
(* REQUIRES inSystemCritical *)

PROCEDURE GetStackPointer( READONLY regs: T ): ADDRESS;

END RTRegisters.
