! Copyright (C) 1992, Digital Equipment Corporation
! All rights reserved.
! See the file COPYRIGHT for a full description.

! Last modified on Wed Jul  1 21:19:07 1992 by rustan

; Rustan Leino
; stack.s
; 24 February 1993

! VAR
!   <* REGISTER "r8" *> currStackLow: ADDRESS;
!   <* REGISTER "r9" *> currStackHigh: ADDRESS;
!
! CONST
!  StackMargin = 10;
!
! PROCEDURE RTStack.SetCurrentStackLimits( low, high: ADDRESS ) =
!   (* REQUIRES inSystemCritical OR executing in system sequence *)
!   (* This procedure allows for a StackMargin word margin *)
!  BEGIN
!    (* low is the lowest address in the stack; high is the lowest
!       address not used in stack *)
!    currStackLow := low + StackMargin;
!    currStackHigh := high;
!    <* ASSERT currStackLow <= currStackHigh *>
!  END RTStack.SetCurrentStackLimits;
!
! PROCEDURE RTStack.GetCurrentStackLimits( VAR low, high: ADDRESS ) =
!   (* REQUIRES inSystemCritical OR executing in system sequence *)
!   BEGIN
!     low := currStackLow - StackMargin;
!     high := currStackHigh
!   END RTStack.GetCurrentStackLimits;

.globl _RTStack__SetCurrentStackLimits
_RTStack__SetCurrentStackLimits:
	mov 1[sp],r8		; currStackLow := low
	add #10,r8		;                 + StackMargin
	mov 2[sp],r9		; currStackHigh := high
	cmp r8,r9
	jgeu $1f

	jsr _RTMisc__AssertFault,r7
$:
	jmp @@sp++

.globl _RTStack__GetCurrentStackLimits
_RTStack__GetCurrentStackLimits:
	mov 1[sp],r0		; r0 := "ADR"( low )
	sub #10,r8		; DEC( currStackLow, StackMargin )
	mov r8,@r0		; low := currStackLow
	add #10,r8		; INC( currStackLow, StackMargin )
	mov 2[sp],r0		; r0 := "ADR"( high )
	mov r9,@r0		; high := currStackHigh
	jmp @@sp++

!
!  Stack overflow checks
!
!  _EXPORT void _M3__CheckStack()
!
!
! _IMPORT char   /* BOOLEAN */ RTStackRep__doStackOverflowChecks;
!
! _EXPORT _M3__CheckStack()
! {
!  char a;
!  if ( ( RTStackRep__currStackLow <= &a && &a < RTStackRep__currStackHigh ) ||
!       ! RTStackRep__doStackOverflowChecks )
!  {
!    return;
!  }
!
!  /* disable further stack overflow checking */
!  RTStackRep__doStackOverflowChecks = 0;
!  /* report the error */
!  RTMisc__StackOverflow();
! }
!
! This function is to be called using
!   jsr __M3__CheckStack,r0

.globl __M3__CheckStack
__M3__CheckStack:
	cmp r8,sp
	jgeu $1f
	jmp is_check_on
$:
	cmp sp,r9
	jgtu okay

is_check_on:
!	mov r0,@--sp	; push return address on stack
	mov _RTStackRep__doStackOverflowChecks,r0
	cmp #0,r0
!	mov @sp++,r0	; pop return address into r0; this doesn't change flags
	jeq okay

	jsr _RTMisc__StackOverflow,r7
okay:
!	jmp @r0
	jmp @@sp++

; end of stack.s
