(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb 28 12:02:40 PST 1992 by kalsow     *)
(*      modified on Mon Nov 18 15:10:00 PST 1991 by muller     *)

UNSAFE INTERFACE RTStack;

TYPE
  T = UNTRACED REF ARRAY OF INTEGER;
  (* a thread stack *)

CONST
  PointerAlignment = 2;
  (* The C compiler allocates all pointers on 'PointerAlignment'-byte
     boundaries.  The garbage collector scans thread stacks, but only
     looks at these possible pointer locations.  Setting this value
     smaller than is needed will only make your system run slower.
     Setting it too large will cause the collector to collect storage
     that is not free. *)

PROCEDURE New (size: INTEGER): T;
(* Allocate a thread stack with at least 'size' usable INTEGERs of storage,
   unmap its guard page, and return it. *)

PROCEDURE Dispose (t: T);
(* Dispose of 't' and remap its guard page. *)

PROCEDURE GetBounds (t: T;  VAR(*OUT*) first, last: ADDRESS);
(* returns the range of usable addresses in stack 't': [first .. last) *)

END RTStack.

