(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Mon Sep 14 10:14:39 PDT 1992 by rustan     *)
(*      modified on Thu Mar 12 12:10:27 PST 1992 by muller     *)
(*      modified on Thu Jan 30 14:07:47 PST 1992 by kalsow     *)

INTERFACE RT0;

(* This interface is "the bottom of the world".  It contains
   types and constants that are shared by multiple modules of
   the runtime and/or the compiler and linker.

   If you're using this interface, you're a wizard!

   This interface and its implemenation MUST NOT import any
   other interface.
*)

(*------------------------------------ compiler generated data structures ---*)

(* These types CANNOT be changed without a synchronized change to the
   output of the compiler *)

TYPE
  Typecode    = CARDINAL;
  String      = UNTRACED REF CHAR;    (* a '\000' terminated string *)

TYPE
  GlobalPair = RECORD    (* must agree with that defined in compiler/linker *)
    addr          : ADDRESS;
    tracedOffsets : UNTRACED REF INTEGER
  END;

TYPE (* one of these is generated for each compilation unit *)
  ModuleInfo = UNTRACED REF RECORD
    init         : PROCEDURE ();
    globals      : UNTRACED REF GlobalPair
  END;


  TypeDefinition = UNTRACED REF Typecell;

  Typecell = RECORD
    typecode         : Typecode;
    lastSubTypeTC    : Typecode;
(** selfID           : INTEGER;                                   KRML **)
(** selfLink         : TypeDefinitionPtr;                         KRML **)
(** fpInfo           : ADDRESS; (* reserved for RTTypeFP *)       KRML **)
(** traced           : BOOLEAN;                                   KRML **)

    dataOffset       : INTEGER;
        (* for object types, the quantity to add to the address of the object
             to get to the fields that belong to this object type;
           for refs, unused;
           for open arrays, the quantity to add to the address of the array
             to get to the elements *)
    dataSize         : INTEGER;
        (* for object types, the size of the fields that belong to this
             object type;
           for refs, the size of the referent;
           for open array types, the size of the "open overhead", including
             padding to align the elements; i.e. ADR (a[0]) - ADR (a) *)
(** dataAlignment    : INTEGER;                                   KRML **)
        (* for object types, the alignment constraint for the fields that
             belong to this object type;
           for refs, the alignment of the referent;
           for open arrays, the alignment of the full array, including
             the header *)

    methodOffset     : INTEGER;
(** methodSize       : INTEGER;                                   KRML **)
    nDimensions      : INTEGER; (* > 0 iff open array *)
    elementSize      : INTEGER;
    defaultMethods   : ADDRESS; (* # NIL iff object type *)
    remoteMethods    : ADDRESS; (* # NIL iff network object type *)(*new KRML*)
(** setupProc        : TypeSetupProc; (* called by RTMisc.Run *)  KRML **)
(** mapProc          : TypeMapProc;   (* called by RTType.Visit *)KRML **)
    tracedOffsets    : UNTRACED REF INTEGER;                (* new KRML *)
    initProc         : TypeInitProc;  (* called by NEW *)
(** brand            : String;                                    KRML **)
(** name             : String;                                    KRML **)
(** parentLink       : TypeDefinitionPtr;                         KRML **)
    parent           : TypeDefinition;
(** children         : TypeDefinition;                            KRML **)
(** sibling          : TypeDefinition;                            KRML **)
  END;

TYPE
  RefType    = { Traced, Untraced, Proc };
  RefTypeSet = SET OF RefType;

TYPE  (* NOTE: VisitProcs must be top-level procedures *)
  VisitProc  = PROCEDURE (arg   : REFANY;
                          field : ADDRESS;
                          base  : ADDRESS;
                          type  : RefType) RAISES ANY;

TYPE
  ModuleMapProc = PROCEDURE (visit : VisitProc;
                             arg   : REFANY;
                             mask  : RefTypeSet);

  TypeMapProc = PROCEDURE (visit : VisitProc;
                           arg   : REFANY;
                           ref   : ADDRESS;
                           mask  : RefTypeSet);

  TypeInitProc  = PROCEDURE (ref: ADDRESS);
(*************************** KRML
  TypeSetupProc = PROCEDURE (def: TypeDefinition);
************************* KRML *)

(*----------------------------------------- compiler generated references ---*)

(*************************** KRML
CONST
  NilTypecode  : Typecode = 0;
  (* KRML  The following typecode has changed to 2 *)
  TextTypecode : Typecode = 1;

(* KRML  The following type is now defined in RTHeapKRML.m3 *)
TYPE
  RefHeader = RECORD
    forwarded : BITS  1 FOR BOOLEAN; (* used during collection *)
    typecode  : BITS 31 FOR Typecode;
  END;
************************* KRML *)

END RT0.

