(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Sep 17 11:36:40 PDT 1992 by rustan     *)
(*      modified on Thu Mar  5 08:36:41 PST 1992 by kalsow     *)
(*      modified on Mon Mar 11 23:31:37 1991 by muller         *)

UNSAFE INTERFACE RTException;

(* This interface provides access to the runtime machinery that
   raises exceptions.  The values of the types defined in this
   interface are generated by the compiler.  Changing any of the
   types below is dangerous. *)

FROM RTExceptSafe IMPORT ExceptionName;
IMPORT RTRegisters;

TYPE
  LOTS = [0.. (*** KRML 999999 ***) 32000 (* new KRML *) ];
       (* for "zero" terminated arrays *)

  ExceptionArg = ADDRESS; (* actually, it's an untyped 1-word field *)

  HandlerClass = { Except, ExceptElse, Finally, Raises, RaisesNone,
                   FinallyProc, Lock };


  RaisesNoneHandler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == RaisesNone *)
  END;

  RaisesHandler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == Raises *)
    handles : UNTRACED REF ARRAY LOTS OF ExceptionName;
  END;

  LockHandler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == Lock *)
    mutex   : MUTEX;
  END;

  FinallyProcHandler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == FinallyProc *)
    proc    : PROCEDURE (frame: ADDRESS) RAISES ANY;
    frame   : ADDRESS;
  END;

  Handler = UNTRACED REF RECORD
    next    : Handler;
    class   : HandlerClass; (* == Except, ExceptElse, Finally *)
    handles : UNTRACED REF ARRAY LOTS OF ExceptionName;
    current : ExceptionName;
    arg     : ExceptionArg;
    jmp_buf : RTRegisters.T
  END;


PROCEDURE RaiseKRML (ex: ExceptionName;  arg: ExceptionArg) RAISES ANY;

END RTException.

