(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Mon Sep 14 11:03:14 PDT 1992 by rustan     *)
(*      modified on Thu Apr  9 09:50:22 PDT 1992 by kalsow     *)
(*      modified on Wed Mar 13 01:21:53 1991 by muller         *)

INTERFACE RTMisc;

IMPORT RTExceptSafe;

(* This interface provides access to miscellaneous runtime routines. *)


(*------------------------------- runtime error reporting -------------------*)

TYPE
  (* Note, the order of the following names must be the same as the order
     of the error messages in the monitor program. *)
  Fault =
    { JoinCalledTwice,
      HeapTooSmall,
      OutOfMemory,
      NegativeArraySize,
      CorruptExceptionStack,
      IncorrectProcessor };

<* EXTERNAL "RTMisc__FatalError" *> PROCEDURE FatalError( f: Fault );
(* report one of the above faults *)

<* EXTERNAL "RTMisc__Success" *> PROCEDURE Success();
(* called to indicate successful termination of program *)

(**********************************************************************
 **  The following procedures are no longer available from Modula-3  **
 **        due to use of more efficient calling convention           **
 **********************************************************************

<* EXTERNAL "RTMisc__AssertFault" *> PROCEDURE AssertFault();
(* report an "assertion failure" runtime error *)

<* EXTERNAL "RTMisc__ReturnFault" *> PROCEDURE ReturnFault();
(* report a "missing RETURN in function" runtime error *)

<* EXTERNAL "RTMisc__CaseFault" *> PROCEDURE CaseFault();
(* report a "missing CASE arm" runtime error *)

<* EXTERNAL "RTMisc__TypecaseFault" *> PROCEDURE TypecaseFault();
(* report a "missing TYPECASE arm" runtime error *)

<* EXTERNAL "RTMisc__RangeFault" *> PROCEDURE RangeFault();
(* report a "value out of range" runtime error *)

<* EXTERNAL "RTMisc__NarrowFault" *> PROCEDURE NarrowFault();
(* report a "narrow failure" runtime error *)

<* EXTERNAL "RTMisc__NilFault" *> PROCEDURE NilFault();
(* report a "dereference NIL" runtime error *)

<* EXTERNAL "RTMisc__RemoteDerefFault" *> PROCEDURE RemoteDerefFault();
(* report a "remote network object dereference" runtime error *)

<* EXTERNAL "RTMisc__StackOverflow" *> PROCEDURE StackOverflow();
(* report a "stack overflow" runtime error *)
**********************************************************************)

<* EXTERNAL "RTMisc__RaisesFault" *>
PROCEDURE RaisesFault( ex_name: RTExceptSafe.ExceptionName );
(* report a "exception not in RAISES clause" runtime error *)

<* EXTERNAL "RTMisc__HandlerFault" *>
PROCEDURE HandlerFault( ex_name: RTExceptSafe.ExceptionName );
(* report an "unhandled exception" runtime error *)

END RTMisc.

