(* Copyright (C) 1990, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)

(* Last modified on Wed Sep  9 16:07:42 PDT 1992 by rustan        *)
(*      modified on Mon Mar 09 20:16:43 PST 1992 by muller        *)

UNSAFE MODULE IO;

(* Note, the procedures in this module may be called before all
   initializations have been done.  Hence, this module cannot
   rely on anything that cannot be initialized statically by the
   C compiler. *)

IMPORT Text, TextF, Processor, IPC;

CONST
  CodePrintChar = 2;
  CodePrintInt = 3;
  CodePrintHex = 4;
  CodePrintTime = 5;

PROCEDURE Put( code: INTEGER; param: INTEGER ) =
  VAR buf: ARRAY [0..3] OF INTEGER;
  BEGIN
    buf[0] := Processor.ID();
    buf[1] := code;
    buf[2] := 0;  (* not used *)
    buf[3] := param;

    IPC.SendBuffer( Processor.HostConnection(), ADR(buf[0]), ADR(buf[3]))
  END Put;

PROCEDURE PutChar( c: CHAR ) =
  BEGIN
    Put( CodePrintChar, ORD( c ))
  END PutChar;

PROCEDURE PutInt( i: INTEGER ) =
  BEGIN
    Put( CodePrintInt, i )
  END PutInt;

PROCEDURE PutHexa( i: INTEGER ) =
  BEGIN
    Put( CodePrintHex, i )
  END PutHexa;

PROCEDURE PutAddr( a: ADDRESS ) =
  BEGIN
    Put( CodePrintHex, LOOPHOLE( a, INTEGER ))
  END PutAddr;

PROCEDURE PutChars( c: UNTRACED REF CHAR; n: INTEGER ) =
  BEGIN
    WHILE n > 0 DO
      PutChar( c^ );
      INC( c, ADRSIZE( CHAR ));
      DEC( n )
    END
  END PutChars;

PROCEDURE PutText( t: Text.T ) =
  BEGIN
    PutChars( ADR(t[0]), NUMBER(t^) - 1 )
  END PutText;

PROCEDURE PutTime() =
  BEGIN
    Put( CodePrintTime, 0 )
  END PutTime;

BEGIN
END IO.
