(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

(* Rustan Leino *)

UNSAFE INTERFACE IPC;

IMPORT Word;


TYPE
  GlobalID = RECORD pid: INTEGER;  id: INTEGER END;
  MsgType = { NewCall, Reply, IncRef, DecRef, New };
  Header = RECORD
      type:  MsgType;
      src:   GlobalID;
      param: INTEGER
    END;
  HeaderPtr = UNTRACED REF Header;

  Surrogate = UNTRACED ROOT OBJECT
      gid:  GlobalID;
      next: Surrogate := NIL
    END;

REVEAL
  NETWORK = ROOT BRANDED "Network Root" OBJECT
      pid: INTEGER; refcount: CARDINAL := 0
    END;

VAR
  sendInProgress: BOOLEAN := FALSE;  (* for use in rtmisc.s *)


PROCEDURE Initialize();
(* Initializes the interrupt handler.  Intended to be called once,
   after what section 5 of the Modula-3D definition calls initialization *)


PROCEDURE Interrupt( isr: Word.T );
(* Intended to be called in the system sequence to handle interrupts. *)


PROCEDURE SendBuffer( destPid: INTEGER; bufFirst, bufLast: ADDRESS );
(* Sends the buffer bounded by bufFirst and bufLast to processor destPid.
   The calling thread is suspended until the send has completed. *)


PROCEDURE SendAndReceiveBuffer( destPid: INTEGER; sendFirst, sendLast: ADDRESS;
                                recFirst, recLast: ADDRESS );
(* Send the buffer bounded by sendFirst and sendLast to processor destPid,
   and, at the same time, prepares to receive a reply message into the buffer
   bounded by recFirst and recLast.  The send and receive buffers are allowed
   to overlap. *)

PROCEDURE EnqueueSurrogate( sur: Surrogate ): BOOLEAN;
(* REQUIRES inSystemCritical *)
(* To be called by the garbage collector only *)
(* Adds the given surrogate object to DecRefQueue.  Returns TRUE if
   caller should call DISPOSE on sur, and FALSE if caller should not
   use the reference any more.  In either case, it is assumed no other
   references to the sur exist. *)

PROCEDURE EmptyAvailLists();
(* To be called before a garbage collection. *)

END IPC.
