(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

(* Rustan Leino *)

INTERFACE Processor;

IMPORT Word;

PROCEDURE ID(): INTEGER;
(* Returns ID of current processor *)

PROCEDURE Main(): INTEGER;
(* Returns ID of main processor *)

PROCEDURE Min(): INTEGER;
(* Returns smallest processor ID *)

PROCEDURE Max(): INTEGER;
(* Returns largest processor ID *)

PROCEDURE Count(): CARDINAL;
(* Return the number of processors *)

PROCEDURE HostConnection(): INTEGER;
(* Returns the ID of the processor connected with the host machine *)

<* EXTERNAL "Processor__PidToDxdy" *>  (* body in rtmisc.s *)
PROCEDURE PidToDxdy( pid: INTEGER ): Word.T;
(* Returns the relative location of a given processor *)

PROCEDURE Of( net: NETWORK ): INTEGER;
(* Returns the processor ID of the processor where 'net' resides.
   'net' must not be NIL. *)

END Processor.
