(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

(* Rustan Leino *)

UNSAFE INTERFACE RPC;

IMPORT IPC, Thread, Word, RT0, RTExceptSafe;

TYPE
  NewClosure = Thread.Closure OBJECT
      client:    IPC.GlobalID;
      callDescr: REF ARRAY OF INTEGER := NIL
    OVERRIDES
      apply := Server
    END;
  ProcType <: ADDRESS;


PROCEDURE Client( params: UNTRACED REF Word.T;
                  proc: ADDRESS; pt: ProcType ): Word.T RAISES ANY;
(* Implements the client part of the RPC protocol *)

PROCEDURE Server( cl: NewClosure ): REFANY;
(* Implements the server part of the RPC protocol *)

PROCEDURE RemoteNew( destPid: INTEGER; def: RT0.TypeDefinition;
                     bindings: ADDRESS ): ADDRESS;
(* Implements the client part of the remove NEW call protocol *)

<* EXTERNAL "RPC__Call" *>
PROCEDURE Call( proc: ADDRESS; paramActualSize: CARDINAL;
                params: UNTRACED REF Word.T;
                VAR retval: Word.T ): RTExceptSafe.ExceptionName;

END RPC.
