/* Copyright (C) 1992, Digital Equipment Corporation           */
/* All rights reserved.                                        */
/* See the file COPYRIGHT for a full description.              */

/* Last modified on Wed Jul  1 21:19:07 1992 by rustan         */

/* Rpc.c */
/* Rustan Leino */

#include "M3Runtime.h"

extern int RPC__call( int proc(), int n, int * params );

/* Call proc, with n words worth of parameters, beginning at params. */
/* Upon normal outcome, return 0, and set *retval to the return value */
/* Upon exceptional outcome, return the exception name and set *retval to */
/* the exception argument */

int * RPC__Call( int proc(), int n, int * params, int * retval )
{
  _TRY_HANDLER handler;
  _PUSH_TRY_ELSE( handler, lbl );
      *retval = RPC__call( proc, n, params );
      _CUT_TO_NEXT_HANDLER( handler );
      return 0;
  lbl:
      *retval = (int)handler.arg;
      return (int *)handler.exception;
}  /* RPC__Call */
