(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

(* Rustan Leino *)

UNSAFE MODULE Surrogate;

IMPORT IPC, System;

CONST
  TableSize = 313;

VAR
  table := ARRAY [ 0..TableSize-1 ] OF IPC.Surrogate { NIL, .. };


PROCEDURE Hash( pid, id: INTEGER ): INTEGER =
  BEGIN
    RETURN ( id DIV 256 + id MOD 256 + pid ) MOD TableSize
  END Hash;

PROCEDURE Find( pid, id: INTEGER; VAR sur: IPC.Surrogate ): BOOLEAN =
  (* REQUIRES inSystemCritical *)
  VAR s: IPC.Surrogate := table[ Hash( pid, id ) ];
      gid := IPC.GlobalID{ pid := pid, id := id };
  BEGIN
    <* ASSERT System.InSystemCritical() *>
    WHILE s # NIL AND s.gid # gid DO s := s.next END;
    IF s = NIL THEN
      RETURN FALSE
    ELSE
      sur := s;  RETURN TRUE
    END
  END Find;

PROCEDURE Add( pid, id: INTEGER; sur: IPC.Surrogate ) =
  (* REQUIRES inSystemCritical *)
  VAR i := Hash( pid, id );
  BEGIN
    <* ASSERT System.InSystemCritical() AND sur.next = NIL *>
    sur.next := table[i];
    table[i] := sur
  END Add;

PROCEDURE Remove( pid, id: INTEGER ) =
  (* REQUIRES inSystemCritical *)
  VAR i := Hash( pid, id );
      s: IPC.Surrogate := table[i];
      back: IPC.Surrogate := NIL;
      gid := IPC.GlobalID{ pid := pid, id := id };
  BEGIN
    <* ASSERT System.InSystemCritical() *>
    WHILE s # NIL AND s.gid # gid DO back := s;  s := s.next END;
    <* ASSERT s # NIL *>
    IF back = NIL
      THEN table[i] := s.next
      ELSE back.next := s.next
    END;
    s.next := NIL
  END Remove;

BEGIN
END Surrogate.
