(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Oct 13 12:49:14 PDT 1992 by rustan     *)

UNSAFE INTERFACE System;

IMPORT Word, Thread, RPC;


(*****  System critical section  *****)

PROCEDURE EnterSystemCritical();
(* Enter system critical section *)

PROCEDURE ExitSystemCritical();
(* Exit system critical section *)

PROCEDURE InSystemCritical(): BOOLEAN;
(* Returns whether or not in critical section *)


(*****  Interrupts  *****)

<* EXTERNAL "System__TurnOffInterrupts" *>
PROCEDURE TurnOffInterrupts();
(* Turn interrupts off.  Called only by EnterSystemCritical. *)

<* EXTERNAL "System__TurnOnInterrupts" *>
PROCEDURE TurnOnInterrupts();
(* Turn interrupts on.  Called only by ExitSystemCritical. *)


(*****  Registers  *****)

<* EXTERNAL "System__InterruptStatus" *>
PROCEDURE InterruptStatus(): Word.T;


(*****  Messages  *****)

<* EXTERNAL "System__InitiateSend" *>
PROCEDURE InitiateSend( start, end: ADDRESS; dxdy: Word.T );
(* Initiates the send of a message.  Must not be called in such a way
   that two sends are attempted concurrently.  This procedure
   will acknowledge any pending Send interrupt.  Called only by
   IPC.InitializeSend.  *)

<* EXTERNAL "System__AcknowledgeInterrupt" *>
PROCEDURE AcknowledgeInterrupt( flags: Word.T );
(* Acknowledges the given interrupt flags *)

<* EXTERNAL "System__PrepareToReceive" *>
PROCEDURE PrepareToReceive( first, last: ADDRESS );
(* Sets up the pointer and limit for the receive.  Does not initiate
   the receive.  Called only by IPC and System modules. *)

PROCEDURE Initialized(): BOOLEAN;
(* Returns whether or not Initialize has been called *)

PROCEDURE Initialize( recFirst, recLast: ADDRESS );
(* REQUIRES NOT inSystemCritical *)
(* Initializes interrupts, and prepares to receive a message in the
   given buffer.  Must only be called once.  Called only from
   IPC.Initialize. *)

<* EXTERNAL "System__StartReceiving" *>
PROCEDURE StartReceiving();
(* Sets things up so that a receive can be handled.  Called only by
   Initialize. *)


(*****  RPC Optimizations *****)

VAR
  RPCThread: Thread.T := NIL;
  RPCClosure: RPC.NewClosure := NIL;


(*****  Processor numbers *****)

(* For a safe interface to the following, see Processor *)
VAR (* CONST *) (* the following variables will be initialized by the loader *)
  procID: INTEGER;
  procMain: INTEGER;
  procMin: INTEGER;
  procMax: INTEGER;
  procHostConnection: INTEGER;

END System.
