(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

UNSAFE MODULE System;


(* ---------------------------- system critical --------------------------- *)

VAR inSystemCritical: BOOLEAN := FALSE;

PROCEDURE InSystemCritical(): BOOLEAN =
  BEGIN
    RETURN inSystemCritical
  END InSystemCritical;

PROCEDURE EnterSystemCritical() =
  BEGIN
    TurnOffInterrupts();
    <* ASSERT NOT inSystemCritical *>
    inSystemCritical := TRUE
  END EnterSystemCritical;

PROCEDURE ExitSystemCritical() =
  BEGIN
    <* ASSERT inSystemCritical *>
    inSystemCritical := FALSE;
    IF initialized THEN TurnOnInterrupts() END
  END ExitSystemCritical;

(* ------------------------------ initialized  ---------------------------- *)

VAR initialized: BOOLEAN := FALSE;

PROCEDURE Initialized(): BOOLEAN =
  BEGIN
    RETURN initialized
  END Initialized;

PROCEDURE Initialize( recFirst, recLast: ADDRESS ) =
  (* REQUIRES NOT inSystemCritical *)
  BEGIN
    EnterSystemCritical();
      <* ASSERT NOT initialized *>
      PrepareToReceive( recFirst, recLast );
      StartReceiving();
      initialized := TRUE;
    ExitSystemCritical()
  END Initialize;

BEGIN
END System.
