; Copyright (C) 1992, Digital Equipment Corporation
; All rights reserved.
; See the file COPYRIGHT for a full description.

; Last modified on Wed Jul  1 21:19:07 1992 by rustan

;  rpc.s
;  Rustan Leino

;  int RPC__call( int proc(), int n, int * params )

.globl _RPC__call
_RPC__call:
	mov bp,@--sp		; function prologue
	mov sp,bp

	mov r3,@--sp		; save register used

	mov 3[bp],r0		; r0 := n
	cmp #0,r0
	jeq do_call
	mov 4[bp],r3		; r3 := params
	add r0,r3		;       + n

copy_params_loop:
	dec r3,r3
	mov @r3,@--sp
	dec r0,r0
	jne copy_params_loop

do_call:
	mov #$1f,@--sp
	jmp @2[bp]
$:

	mov -1[bp],r3		; restore register used

	mov bp,sp		; function epilogue
	mov @sp++,bp
	jmp @@sp++

;  call_rpc_client
;  stack on entry:
;                              pt proc  retaddrCaller netobj otherparams
;  stack before jmp to _RPC__Client:
;    retaddrHere paramPtr proc pt oldbp retaddrCaller netobj otherparams
;  stack on exit:
;                                                     netobj otherparams
;  on exit, all registers have the same value as upon entry, except for
;  r0 which contains the return value of the remote procedure call

.globl _call_rpc_client
_call_rpc_client:
	mov 1[sp],-1[sp]
	mov bp,1[sp]
	inc sp,bp
	dec sp,sp
	mov sp,r0
	add #4,r0
	mov r0,@--sp
	mov #$1f,@--sp
	jmp _RPC__Client
$:
	mov bp,sp
	mov @sp++,bp
	jmp @@sp++

;  end of rpc.s
