; Copyright (C) 1992, Digital Equipment Corporation
; All rights reserved.
; See the file COPYRIGHT for a full description.

; Last modified on Wed Jul  1 21:19:07 1992 by rustan

; system.s
; Rustan Leino
; 13 October 1992

.text

; _system is the start of everything (the bootstrap jumps here immediately)

.globl _system
_system:
	mov #0,imr			; make sure interrupts are off
	mov #start_userseq,apc
	punt				; start the user sequence

	; The first interrupt occurs here.  By the time interrupts have
	; been turned on, _RTMemory__SystemStackHigh will also have been
	; initialized.

	mov _RTMemory__SystemStackHigh,sp
	dec sp,sp			; decrement once for efficiency later
	mov #0,bp
	jmp system_loop_entry
system_loop:
	punt
system_loop_entry:
	mov isr,@sp
	; Stack overflow checks are turned off temporarily, so that
	; a Modula-3 procedure can be called using the system stack.
	; Checks are turned back on again in ThreadF.SwitchToSystemContext
	; as soon as possible.  On return, checks will be on.
	mov #0,_RTStackRep__doStackOverflowChecks
	mov #system_loop,@--sp
	jmp _ThreadF__SwitchToSystemContext

start_userseq:
	mov #0,sp
	mov sp,bp
	mov #userstartup,@--sp		; _main never returns, but we need
					; some sensible return address on the
					; stack, so this one will do nicely
	jmp _main

userstartup:				; a nice name is chosen for this label
	jmp userstartup			; because it will show during any
					; run-time error in the main thread


!
! PROCEDURE System.TurnOffInterrupts();
! PROCEDURE System.TurnOnInterrupts();
!

.globl _System__TurnOffInterrupts
_System__TurnOffInterrupts:
	mov #0,imr
	jmp @@sp++

.globl _System__TurnOnInterrupts
_System__TurnOnInterrupts:
	mov #7,imr
	jmp @@sp++

!
! PROCEDURE System.InterruptStatus(): Word.T;
!

.globl _System__InterruptStatus
_System__InterruptStatus:
	mov isr,r0
	jmp @@sp++

!
! PROCEDURE System.PrepareToReceive( first, last: ADDRESS );
!

.globl _System__PrepareToReceive
_System__PrepareToReceive:
	mov 1[sp],mrp
	mov 2[sp],mrl
	jmp @@sp++

!
! PROCEDURE System.StartReceiving();
!

.globl _System__StartReceiving
_System__StartReceiving:
	mov #5,isr
	jmp @@sp++

;
; PROCEDURE System.InitiateSend( start, end: ADDRESS; dxdy: Word.T );
;

.globl _System__InitiateSend
_System__InitiateSend:		; params: start end dxdy
	mov isr,r0
	and #2,r0
	jeq $1f
	mov #2,isr		; must acknowledge old before issuing new
$:
	inc sp,r0
	mov @r0++,msp
	mov @r0++,msl
	mov @r0,dxdy
	jmp @@sp++

;
; PROCEDURE System.AcknowledgeInterrupt( flags: Word.T );
;

.globl _System__AcknowledgeInterrupt
_System__AcknowledgeInterrupt:
	mov 1[sp],isr
	jmp @@sp++

; end of system.s
