(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Mon Aug 31 12:29:14 PDT 1992 by rustan         *)
(*      modified on Wed May 20 20:53:01 PDT 1992 by muller         *)
(*      modified on Thu Jan 30 09:19:10 PST 1992 by kalsow         *)

UNSAFE INTERFACE ThreadF;
(* KRML.  This interface is unsafe because it reveals the variables
   mainThread and gcThread, and the procedures EnterSystemCritical
   and ExitSystemCritical.  Modifying these variables, either directly
   or by calling Thread procedures to modify the state of these threads,
   or incorrectly calling the procedures in this interface will have
   unknown effects on the run-time system. *)

IMPORT FloatMode, Thread, Word;

(*------------------------------------------------ floating point support ---*)

PROCEDURE MyFPState (): UNTRACED REF FloatMode.ThreadState;
(* returns the saved floating point state for the current thread.
   WARNING: the return value is an untraced pointer to a traced Thread.T!!  *)

(*----------------------------------------------------------------- other ---*)

PROCEDURE SaveThreadState( t: Thread.T );
(* saves the registers and stack pointers of the given thread (almost) as
   if the thread had been suspended via a context switch;  only intended to
   be called from the RTStackKRML module *)

PROCEDURE GetRecordedStackPointer( t: Thread.T ): ADDRESS;
(* returns the most recently recorded stack pointer for thread 't'. *)

PROCEDURE GetRegisterBounds( t: Thread.T; VAR low, high: UNTRACED REF Word.T );
(* returns the addresses bounding the buffer which stores the most
   recently recorded registers for thread 't'. *)

CONST
  MainStackSize = 1024;    (* the size of the main thread's stack in words *)
  SystemStackSize = 200;   (* the size of the system thread's stack in words *)

VAR
  self: Thread.T;          (* The currently running thread, linked with all
                              other active threads.  This variable provided
                              in this interface only so that the assembly
                              routines in rtmisc.s can reach it.  All other
                              clients should use Thread.Self(). *)
  mainThread: Thread.T := NIL;  (* the main thread *)
  gcThread: Thread.T;      (* the thread running the garbage collector *)
  systemThread: Thread.T;  (* the thread running in the system sequence *)
  userSequenceThread: Thread.T := NIL;
                           (* the thread executing in the user sequence when
                              the garbage collector is invoked in the system
                              sequence *)
  gcInvokedFromSystemThread: BOOLEAN := FALSE;
                           (* indicates whether or not the current garbage
                              collector invocation was started in the
                              system thread; this variable is only used in
                              conjunction with a g.c. invocation *)
  waitingForSpace: Thread.T := NIL;
                           (* list of threads waiting for more space to
                              become available; this variable should only
                              be written by the RTHeapKRML module *)

VAR currentHandlers: ADDRESS := NIL;
(* pointer to top current thread's exception stack *)


PROCEDURE Schedule( t: Thread.T );
(* schedule a list of given threads; see implementation for more details *)

PROCEDURE ScheduleOne( VAR q: Thread.T );
(* Removes the first thread from q and schedules it. *)

PROCEDURE Suspend( VAR q: Thread.T );
(* suspends the current thread on the given queue *)

PROCEDURE AlertSuspend( pq: UNTRACED REF Thread.T ) RAISES {Thread.Alerted};
(* alertably suspends the current thread on pq^ *)

PROCEDURE TestAndClearAlert(): BOOLEAN;
(* If the calling thread has been marked alerted, return TRUE and unmark it.
   Otherwise, return FALSE. *)

PROCEDURE InvokeGarbageCollector();
(* switches threads to run the garbage collector; once it has finished,
   the calling thread will continue executing *)

PROCEDURE YieldFromCollector();
(* switches threads back from garbage collector to the calling thread *)

PROCEDURE SwitchToSystemContext( isr: Word.T );
(* switches threads to run the system thread (the interrupt handler);
   should only be called from the _system procedure on interrupts *)

END ThreadF.
