(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: M3LinkerKRML.i3                                       *)
(* Last Modified On Wed Sep  2 10:27:40 PDT 1992 By rustan     *)

INTERFACE M3LinkerKRML;

IMPORT M3Linker, M3LinkMap, Wr;
FROM M3Linker IMPORT LinkError;


TYPE S <: REFANY;


(* the New procedure creates an empty object, which is initialized
   by calling the following procedures *)
PROCEDURE New( nRefs, nObjects, nOpaques: CARDINAL ): S;

PROCEDURE AddRefType( s: S; t: M3Linker.Type ) RAISES {LinkError};
PROCEDURE AddObjType( s: S; t: M3Linker.Type ) RAISES {LinkError};

PROCEDURE AddOpaqueName( s: S; t: M3Linker.Type );
PROCEDURE AddOpaques( s: S; ul: M3Linker.UnitList; typeMap: M3LinkMap.T )
    RAISES {LinkError};

PROCEDURE FindChildren( s: S ) RAISES {LinkError};
PROCEDURE AssignTypecodes( s: S ) RAISES {LinkError};
PROCEDURE CheckRevelations( s: S; ul: M3Linker.UnitList ) RAISES {LinkError};
PROCEDURE FixSizes( s: S ) RAISES {LinkError};
PROCEDURE CheckTypes( s: S ) RAISES {LinkError};

(* the following procedures are for generating code in _m3main.c *)
PROCEDURE GeneratePredecls( s: S; wr: Wr.T );
PROCEDURE GenerateTypecells( s: S; wr: Wr.T );
PROCEDURE GenerateTypecellList( s: S; wr: Wr.T );
PROCEDURE GenerateTCs( s: S; wr: Wr.T );
PROCEDURE GetTcAddress( s: S ): CARDINAL;  (* return TYPECODE(ADDRESS) *)
PROCEDURE PrintTypeSummary( s: S; wr: Wr.T  );

END M3LinkerKRML.
