/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include "tar.h"
#include "/ex32/include/sys/mknod.h"

static int ask = 0, skip = 0;
static int ask_ch = 'y';

void Fatal(char *msg)
{
  fprintf(stderr, "Fatal! %s!\n", msg);
  exit(1);
}

static int getnextslashpos (char * string, int pos)
  {
    if (string [pos] == '\0') {
      return pos;
    }
    do {
      pos++;
    } while ((string [pos] != '\0') && (string [pos] != '/'));
    return pos;
  }

static char actual_dir [256] = "";
static char skip_dir [256] = "";
static char buf[512];

static void check_directory (char * path)
  {
    int i, j, end = 0, r, len;
    char dirname [256], substr1 [256], substr2 [256];
    
    for (i = 0; i < strlen (path); i++) {
      if (path [i] == '/') {
        end = i;
      }
    }
    for (i = 0; i <= end; i++) {
      dirname [i] = path [i];
      dirname [i+1] = '\0';
    }
    
    if (strcmp (actual_dir, dirname) == 0) {
      return;
    }
    
    len = strlen (dirname);
    substr1 [0] = '\0';
    substr2 [0] = '\0';
    i = 0; j = 0;
    while (j < len - 1) {
      i = getnextslashpos (actual_dir, i);
      j = getnextslashpos (dirname, j);
      strncpy (substr1, actual_dir, i);
      substr1 [i] = '\0';
      strncpy (substr2, dirname, j);
      substr2 [j] = '\0';
      if (strcmp (substr1, substr2) != 0) {
        ask_ch = 'y';
        if (ask) {
	  do {
	    printf ("Do you want directory %s ? (y/n) ", substr2);
	    fflush (stdout);
	    ask_ch = getchar ();
	  } while ((ask_ch != 'y') && (ask_ch != 'n'));
	}
	if (ask_ch == 'y') {
          printf ("Making directory %s\n", substr2);
          r = mknod (substr2, MKN_DIR, 0); skip = 0;
	} else {
	  printf ("Skipping directory %s\n", substr2);
	  strcpy (skip_dir, substr2); skip = 1;
	}
        if (r < 0) {
	  printf ("mytar: create directory for %s failed\n", substr2);
	  exit (-1);
        }
      }
    }
    strcpy (actual_dir, dirname);
  }

static skip_file (int fd, int size)
  {
    int dsize;
    while (size) {
      if (size < 512) {
        dsize = size;
      } else {
        dsize = 512;
      }
      read (fd, buf, 512);
      size -= dsize;
    }
  }

main(int argc, char **argv)
{
  int i = 1;
  if (argc < 2)
  {
    fprintf(stderr, "mytar tarfile . . .\n");
    exit(1);
  }
  
  for (i = 1; i < argc; i++) {
    if (strcmp (argv [i], "-a") == 0) {
      ask = 1;
    } else {
      tarread (argv[i]);
    }
  }
}

typedef struct {
  char name [100];
  char mode [8];
  char uid [8];
  char gid [8];
  char size [12];
  char mtime [12];
  char chksum [8];
  char typeflag [1];
  char linkname [100];
  char magic [6];
  char version [2];
  char uname [32];
  char gname [32];
  char devmajor [8];
  char devminor [8];
  char prefix [155];
  char filler [12];
} TARREC;


tarread(char *fname)
{
  TARREC header;
  int r;
  int f;
  long perm, uid, gid, size, time, csum;
  int dsize;
  char changed_name [80], subname [80];
  long posn=0, cur_pos;
  
  if ((f = open(fname, O_RDONLY | O_BINARY, S_IREAD)) < 0) {
    printf ("mytar: cannot open tarfile %s\n", fname);
    return -1;
  }

  while (1)
  {
    if (read(f, &header, sizeof (header)) < 0) {
      break;
    }
    if (header.name[0] == 0) {
      printf ("mytar: untared %s\n", fname);
      break;
    }
    sscanf(header.mode, "%lo", &perm);
    sscanf(header.uid, "%lo", &uid);
    sscanf(header.gid, "%lo", &gid);
    sscanf(header.size, "%lo", &size);
    sscanf(header.mtime, "%lo", &time);
    strcpy (changed_name, header.name);
    printf("%08lx %6lo %12ld %s", posn, perm, size, changed_name);
    if (header.typeflag[1] == 0x32)
      printf(" -> %s", header.filler);
    printf("\n"); fflush (stdout);
    posn += 512 + (size+511) & ~511;
/***    
    printf("%6lo %02x %12ld %s\n", perm, header.typeflag[0], size, changed_name);
    if (changed_name[strlen(changed_name)-1] == '/')
***/    

    strcpy (subname, changed_name);
    subname [strlen (skip_dir)] = '\0';    
    if (skip && (strcmp (skip_dir, subname) == 0)) {
      skip_file (f, size);
      continue;
    }

    if (header.typeflag [0] == DIRTYPE) {
      if (changed_name [strlen (changed_name) - 1] == '/') {
        changed_name[strlen(changed_name)-1] = 0;
      }
      
      ask_ch = 'y';
      if (ask) {
	do {
	  printf ("Do you want directory %s ? (y/n) ", changed_name);
	  fflush (stdout);
	  ask_ch = getchar ();
	} while ((ask_ch != 'y') && (ask_ch != 'n'));
      }
      if (ask_ch == 'y') {
        printf ("Making directory %s\n", changed_name);
        r = mknod (changed_name, MKN_DIR, 0); skip = 0;
      } else {
        printf ("Skipping directory %s\n", changed_name);
        strcpy (skip_dir, changed_name); skip = 1;
      }
      strcpy (actual_dir, changed_name);	/* new actual dir !!! */
      
      if (r < 0) {
	printf ("mytar: cannot create directory %s\n", changed_name);
	exit (-1);
      }
    } else if ((header.typeflag [0] == REGTYPE) || 
               (header.typeflag [0] == AREGTYPE)) {
      check_directory (changed_name);
      if (skip) {
        skip_file (f, size);
	continue;
      }
      
      r = open(changed_name, O_WRONLY|O_BINARY|O_CREAT|O_EXCL,S_IWRITE|S_IREAD);
      printf ("--  Creating file %s\n", changed_name);
      if (r < 0) {
        printf ("mytar: cannot open file %s\n", changed_name);
	exit (-1);
      } else {
        while (size) {
          if (size < 512) {
            dsize = size;
          } else {
            dsize = 512;
	  }
          read(f, buf, 512);
          if (write(r, buf, dsize) < dsize) {
            printf("mytar: out of disk space\n");
            exit(1);
          }
          size -= dsize;
        }
        close(r);
      }
    } else if (header.typeflag [0] == LNKTYPE) {
      printf ("mytar: hard link ignored\n");
    } else if (header.typeflag [0] == SYMTYPE) {
      printf ("mytar: symbolic link ignored\n");
    } else {
      printf ("mytar: unsupported typeflag %c\n", header.typeflag [0]);
      exit (-1);
    }
    fflush (stdout);
  }
  printf ("mytar: closing tarfile\n");
  close(f);
}
