/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <stdio.h>
#include "/ex32/include/sys/mknod.h"

int main (int argc, char ** argv)
  {
    int result;
    
    if (argc != 2) {
      fprintf (stderr, "usage: %s dirname\n", argv [0]);
      return -1;
    }
    result = mknod (argv [1], MKN_DIR, 0);
    if (result < 0) {
      fprintf (stderr, "%s: cannot create %s\n", argv [0], argv [1]);
    }
    return result;
  }
