/* This file is intended to be compiled with Turbo-C */

#include <stdio.h>
#include <fcntl.h>

fatal(char *s)
{
  fputs(s, stderr);
  exit(1);
}

main(int argc, char **argv)
{
  int f1;
  int f2;
  char buf1[512];
  char buf2[512];
  int len1, len2;
  
  if (argc < 3)
    fatal("Usage: udpate srcfile destfile\n");

  f1 = open(argv[1], O_RDONLY | O_BINARY);
  if (f1 < 0)
    fatal("Cannot open src file\n");

  f2 = open(argv[2], O_RDONLY | O_BINARY);

  if (f2 >= 0)
    while (1)
    {
      len1 = read(f1, buf1, 512);
      len2 = read(f2, buf2, 512);
      if (len1 != len2)
        break;
      if (memcmp(buf1, buf2, len1))
        break;
      if (len1)
        continue;
      exit(0);
    }

  if (f2 >= 0)
  {
    printf("File `%s' updated\n", argv[2]);
    close(f2);
  }
  else
    printf("File `%s' created\n", argv[2]);

  lseek(f1, 0L, 0);
  f2 = open(argv[2], O_CREAT | O_TRUNC | O_RDWR | O_BINARY, 0);
  while (1)
  {
    len1 = read(f1, buf1, 512);
    if (len1 == 0)
      break;
    len2 = write(f2, buf1, len1);
  }
  close(f1);
  close(f2);
  exit(0);
}
