/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <std.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include "/ex32/include/sys/message.h"
#include "/ex32/include/sys/syscalls.h"
#include "/ex32/include/signal.h"

#define TRUE			1
#define FALSE			0
#undef  DEBUG

#define MAX_ARGS		30
#define ARG_LEN			40

extern int __pid;
extern void init_symbols (char *);
extern char * get_sym (int);

static void    	sigsegv_handler (void);
static int     	start_child (char **);
static int	tr_pid;

static panic (int proc, char * string)
  {
    printf ("tracer panic (%d): %s\n", proc, string);
    kill (proc, SIGKILL);
    exit (-1);
  }

static void sigsegv_handler ()
  {
    REGS regs; char * symbol;
    _procget (tr_pid, &regs);
    symbol = get_sym (regs.eip);
    printf ("tracer: segmentation violation %d %s: eip = %d = 0x%x\n", 
             tr_pid, symbol, regs.eip, regs.eip);
    kill (tr_pid, SIGKILL);			 /* kill proc  */
    exit (0);					/* I have done my job. */
  } 

static char * old_ptr;
  
static void sigtrap_handler ()
  {
    REGS regs; char * symbol;
    _procget (tr_pid, &regs);
    symbol = get_sym (regs.eip);
    if (symbol != old_ptr) {
      old_ptr = symbol;
      printf ("tracer: %d %s: eip = %d = 0x%x\n", 
              tr_pid, symbol, regs.eip, regs.eip);
    }
    signal (SIGTRAP, (SignalHandler) &sigtrap_handler);
/***    
    _procjmp (tr_pid, regs);
***/    
    kill (tr_pid, SIGUSR1);			 /* restart proc  */
  }

static int start_child (char ** argv)
  {
     int child; int i = 0;
     
#ifdef DEBUG
     printf ("exec (");
     while (argv [i] != 0) {
       printf ("%s ", argv [i]); i++;
     }
     printf (")\n");
     fflush (stdout);
#endif

     init_symbols (argv [0]);     
     
     if ((child = fork ()) == 0) {
       /* child */
       _setexec (EXEC_EMU | EXEC_DEBUG);
       if (execve (argv [0], (const char **) argv, environ) < 0) {
         panic (child, "cannot exec");
	 exit (-1);
       }
     }
     /* parent */
     return child;
  }


void main (int argc, char ** argv, char ** envp)
  {
    int status;
    
    if (argc < 2) {
      printf ("usage: %s program arguments ...\n", argv [0]);
      exit (-1);
    }
    
    signal (SIGSEGV,  (SignalHandler) &sigsegv_handler);
    signal (SIGTRAP,  (SignalHandler) &sigtrap_handler);
    
    tr_pid = start_child (&argv [1]);
    /* parent */
    while (wait (&status) != tr_pid) ;
    printf ("tracer: process %d has said good bye with %d\n", tr_pid, status);
  }
