/*	graphics.h

	Definitions for Graphics Package.

        Copyright (c) Borland International 1987,1988,1990
	All Rights Reserved.
*/

#if __STDC__
#define _Cdecl
#else
#define _Cdecl	cdecl
#endif

#if     !defined(__GRAPHX_DEF_)
#define __GRAPHX_DEF_

enum graphics_errors {		/* graphresult error return codes */
	grOk		   =   0,
	grNoInitGraph	   =  -1,
	grNotDetected	   =  -2,
	grFileNotFound	   =  -3,
	grInvalidDriver    =  -4,
	grNoLoadMem	   =  -5,
	grNoScanMem	   =  -6,
	grNoFloodMem	   =  -7,
	grFontNotFound	   =  -8,
	grNoFontMem	   =  -9,
	grInvalidMode	   = -10,
	grError 	   = -11,   /* generic error */
	grIOerror	   = -12,
	grInvalidFont	   = -13,
	grInvalidFontNum   = -14,
	grInvalidVersion   = -18
};

enum graphics_drivers { 	/* define graphics drivers */
	DETECT, 		/* requests autodetection */
	CGA, MCGA, EGA, EGA64, EGAMONO, IBM8514,	/* 1 - 6 */
	HERCMONO, ATT400, VGA, PC3270,			/* 7 - 10 */
	CURRENT_DRIVER = -1
};

enum graphics_modes {		/* graphics modes for each driver */
    CGAC0      = 0,  /* 320x200 palette 0; 1 page	*/
    CGAC1      = 1,  /* 320x200 palette 1; 1 page	*/
    CGAC2      = 2,  /* 320x200 palette 2: 1 page	*/
    CGAC3      = 3,  /* 320x200 palette 3; 1 page	*/
    CGAHI      = 4,  /* 640x200 1 page			*/
    MCGAC0     = 0,  /* 320x200 palette 0; 1 page	*/
    MCGAC1     = 1,  /* 320x200 palette 1; 1 page	*/
    MCGAC2     = 2,  /* 320x200 palette 2; 1 page	*/
    MCGAC3     = 3,  /* 320x200 palette 3; 1 page	*/
    MCGAMED    = 4,  /* 640x200 1 page			*/
    MCGAHI     = 5,  /* 640x480 1 page			*/
    EGALO      = 0,  /* 640x200 16 color 4 pages	*/
    EGAHI      = 1,  /* 640x350 16 color 2 pages	*/
    EGA64LO    = 0,  /* 640x200 16 color 1 page 	*/
    EGA64HI    = 1,  /* 640x350 4 color  1 page 	*/
    EGAMONOHI  = 0,  /* 640x350 64K on card, 1 page - 256K on card, 4 pages */
    HERCMONOHI = 0,  /* 720x348 2 pages 		*/
    ATT400C0   = 0,  /* 320x200 palette 0; 1 page	*/
    ATT400C1   = 1,  /* 320x200 palette 1; 1 page	*/
    ATT400C2   = 2,  /* 320x200 palette 2; 1 page	*/
    ATT400C3   = 3,  /* 320x200 palette 3; 1 page	*/
    ATT400MED  = 4,  /* 640x200 1 page			*/
    ATT400HI   = 5,  /* 640x400 1 page			*/
    VGALO      = 0,  /* 640x200 16 color 4 pages	*/
    VGAMED     = 1,  /* 640x350 16 color 2 pages	*/
    VGAHI      = 2,  /* 640x480 16 color 1 page 	*/
    PC3270HI   = 0,  /* 720x350 1 page			*/
    IBM8514LO  = 0,  /* 640x480 256 colors		*/
    IBM8514HI  = 1   /*1024x768 256 colors		*/
};

/* Colors for setpalette and setallpalette */

#if	!defined(__COLORS)
#define __COLORS

enum COLORS {
    BLACK,		    /* dark colors */
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,		    /* light colors */
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE
};
#endif

enum CGA_COLORS {
    CGA_LIGHTGREEN     = 1,		/* Palette C0 Color Names	*/
    CGA_LIGHTRED       = 2,
    CGA_YELLOW	       = 3,

    CGA_LIGHTCYAN      = 1,		/* Palette C1 Color Names	*/
    CGA_LIGHTMAGENTA   = 2,
    CGA_WHITE	       = 3,

    CGA_GREEN	       = 1,		/* Palette C2 Color Names	*/
    CGA_RED	       = 2,
    CGA_BROWN	       = 3,

    CGA_CYAN	       = 1,		/* Palette C3 Color Names	*/
    CGA_MAGENTA        = 2,
    CGA_LIGHTGRAY      = 3
};


enum EGA_COLORS {
    EGA_BLACK		 =  0,	    /* dark colors */
    EGA_BLUE		 =  1,
    EGA_GREEN		 =  2,
    EGA_CYAN		 =  3,
    EGA_RED		 =  4,
    EGA_MAGENTA 	 =  5,
    EGA_BROWN		 =  20,
    EGA_LIGHTGRAY	 =  7,
    EGA_DARKGRAY	 =  56,     /* light colors */
    EGA_LIGHTBLUE	 =  57,
    EGA_LIGHTGREEN	 =  58,
    EGA_LIGHTCYAN	 =  59,
    EGA_LIGHTRED	 =  60,
    EGA_LIGHTMAGENTA	 =  61,
    EGA_YELLOW		 =  62,
    EGA_WHITE		 =  63
};

enum line_styles {		/* Line styles for get/setlinestyle */
	SOLID_LINE   = 0,
	DOTTED_LINE  = 1,
	CENTER_LINE  = 2,
	DASHED_LINE  = 3,
	USERBIT_LINE = 4,	/* User defined line style */
};

enum line_widths {		/* Line widths for get/setlinestyle */
	NORM_WIDTH  = 1,
	THICK_WIDTH = 3,
};

enum font_names {
	DEFAULT_FONT	= 0,	/* 8x8 bit mapped font */
	TRIPLEX_FONT	= 1,	/* "Stroked" fonts */
	SMALL_FONT	= 2,
	SANS_SERIF_FONT = 3,
	GOTHIC_FONT	= 4
};

#define HORIZ_DIR	0	/* left to right */
#define VERT_DIR	1	/* bottom to top */

#define USER_CHAR_SIZE	0	/* user-defined char size */

enum fill_patterns {		/* Fill patterns for get/setfillstyle */
	EMPTY_FILL,		/* fills area in background color */
	SOLID_FILL,		/* fills area in solid fill color */
	LINE_FILL,		/* --- fill */
	LTSLASH_FILL,		/* /// fill */
	SLASH_FILL,		/* /// fill with thick lines */
	BKSLASH_FILL,		/* \\\ fill with thick lines */
	LTBKSLASH_FILL, 	/* \\\ fill */
	HATCH_FILL,		/* light hatch fill */
	XHATCH_FILL,		/* heavy cross hatch fill */
	INTERLEAVE_FILL,	/* interleaving line fill */
	WIDE_DOT_FILL,		/* Widely spaced dot fill */
	CLOSE_DOT_FILL, 	/* Closely spaced dot fill */
	USER_FILL		/* user defined fill */
};

enum putimage_ops {		/* BitBlt operators for putimage */
	COPY_PUT,		/* MOV */
	XOR_PUT,		/* XOR */
	OR_PUT, 		/* OR  */
	AND_PUT,		/* AND */
	NOT_PUT 		/* NOT */
};

enum text_just {		/* Horizontal and vertical justification
				   for settextjustify */
	LEFT_TEXT	= 0,
	CENTER_TEXT	= 1,
	RIGHT_TEXT	= 2,

	BOTTOM_TEXT	= 0,
     /* CENTER_TEXT	= 1,  already defined above */
	TOP_TEXT	= 2
};


#define MAXCOLORS 15

struct palettetype {
	unsigned char size;
	signed char colors[MAXCOLORS+1];
};

struct linesettingstype {
	int linestyle;
	unsigned upattern;
	int thickness;
};

struct textsettingstype {
	int font;
	int direction;
	int charsize;
	int horiz;
	int vert;
};

struct fillsettingstype {
	int pattern;
	int color;
};

struct pointtype {
	int x, y;
};

struct viewporttype {
	int left, top, right, bottom;
	int clip;
};

struct arccoordstype {
	int x, y;
	int xstart, ystart, xend, yend;
};

#ifdef __cplusplus
extern "C" {
#endif
void	    _Cdecl arc(int __x, int __y, int __stangle, int __endangle,
			  int __radius);
void	    _Cdecl bar(int __left, int __top, int __right, int __bottom);
void	    _Cdecl bar3d(int __left, int __top, int __right, int __bottom,
			    int __depth, int __topflag);
void	    _Cdecl circle(int __x, int __y, int __radius);
void	    _Cdecl cleardevice(void);
void	    _Cdecl clearviewport(void);
void	    _Cdecl closegraph(void);
void	    _Cdecl detectgraph(int  *__graphdriver,int  *__graphmode);
void	    _Cdecl drawpoly(int __numpoints, int  *__polypoints);
void	    _Cdecl ellipse(int __x, int __y, int __stangle, int __endangle,
			      int __xradius, int __yradius);
void	    _Cdecl fillellipse( int __x, int __y, int __xradius, int __yradius );
void	    _Cdecl fillpoly(int __numpoints, int  *__polypoints);
void	    _Cdecl floodfill(int __x, int __y, int __border);
void	    _Cdecl getarccoords(struct arccoordstype  *__arccoords);
void	    _Cdecl getaspectratio(int  *__xasp, int  *__yasp);
int	    _Cdecl getbkcolor(void);
int	    _Cdecl getcolor(void);
struct palettetype  *  _Cdecl getdefaultpalette( void );
char *	    _Cdecl getdrivername( void );
void	    _Cdecl getfillpattern(char  *__pattern);
void	    _Cdecl getfillsettings(struct fillsettingstype  *__fillinfo);
int	    _Cdecl getgraphmode(void);
void	    _Cdecl getimage(int __left, int __top, int __right, int __bottom,
			       void  *__bitmap);
void	    _Cdecl getlinesettings(struct linesettingstype  *__lineinfo);
int	    _Cdecl getmaxcolor(void);
int	    _Cdecl getmaxmode(void);
int	    _Cdecl getmaxx(void);
int	    _Cdecl getmaxy(void);
char *	    _Cdecl getmodename( int __mode_number );
void	    _Cdecl getmoderange(int __graphdriver, int  *__lomode,
				   int  *__himode);
unsigned    _Cdecl getpixel(int __x, int __y);
void	    _Cdecl getpalette(struct palettetype  *__palette);
int	    _Cdecl getpalettesize( void );
void	    _Cdecl gettextsettings(struct textsettingstype  *__texttypeinfo);
void	    _Cdecl getviewsettings(struct viewporttype  *__viewport);
int	    _Cdecl getx(void);
int	    _Cdecl gety(void);
void	    _Cdecl graphdefaults(void);
char *	    _Cdecl grapherrormsg(int __errorcode);
void	    _Cdecl _graphfreemem(void  *__ptr, unsigned __size);
void  *     _Cdecl _graphgetmem(unsigned __size);
int	    _Cdecl graphresult(void);
unsigned    _Cdecl imagesize(int __left, int __top, int __right, int __bottom);
void	    _Cdecl initgraph(int   *__graphdriver,
				int   *__graphmode,
				char  *__pathtodriver);
int	    _Cdecl installuserdriver( char  *__name, int (*detect)(void));
int	    _Cdecl installuserfont( char  *__name );
void	    _Cdecl line(int __x1, int __y1, int __x2, int __y2);
void	    _Cdecl linerel(int __dx, int __dy);
void	    _Cdecl lineto(int __x, int __y);
void	    _Cdecl moverel(int __dx, int __dy);
void	    _Cdecl moveto(int __x, int __y);
void	    _Cdecl outtext(char  *__textstring);
void	    _Cdecl outtextxy(int __x, int __y, char  *__textstring);
void	    _Cdecl pieslice(int __x, int __y, int __stangle, int __endangle,
			       int __radius);
void	    _Cdecl putimage(int __left, int __top, void  *__bitmap, int __op);
void	    _Cdecl putpixel(int __x, int __y, int __color);
void	    _Cdecl rectangle(int __left, int __top, int __right, int __bottom);
void	    _Cdecl restorecrtmode(void);
void	    _Cdecl sector( int __X, int __Y, int __StAngle, int __EndAngle,
			      int __XRadius, int __YRadius );
void	    _Cdecl setactivepage(int __page);
void	    _Cdecl setallpalette(struct palettetype  *__palette);
void	    _Cdecl setaspectratio( int __xasp, int __yasp );
void	    _Cdecl setbkcolor(int __color);
void	    _Cdecl setcolor(int __color);
void	    _Cdecl setfillpattern(char  *__upattern, int __color);
void	    _Cdecl setfillstyle(int __pattern, int __color);
unsigned    _Cdecl setgraphbufsize(unsigned __bufsize);
void	    _Cdecl setgraphmode(int __mode);
void	    _Cdecl setlinestyle(int __linestyle, unsigned __upattern,
				   int __thickness);
void	    _Cdecl setpalette(int __colornum, int __color);
void	    _Cdecl setrgbpalette(int __colornum,
				    int __red, int __green, int __blue);
void	    _Cdecl settextjustify(int __horiz, int __vert);
void	    _Cdecl settextstyle(int __font, int __direction, int __charsize);
void	    _Cdecl setusercharsize(int __multx, int __divx,
				      int __multy, int __divy);
void	    _Cdecl setviewport(int __left, int __top, int __right, int __bottom,
				  int __clip);
void	    _Cdecl setvisualpage(int __page);
void	    _Cdecl setwritemode( int __mode );
int	    _Cdecl textheight(char  *__textstring);
int	    _Cdecl textwidth(char  *__textstring);

#ifdef __cplusplus
}
#endif


#endif
