/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#ifndef __SIGNAL_H
#define __SIGNAL_H

#define SIGHUP		1	/* hangup */
#define SIGINT		2	/* interrupt */
#define SIGQUIT		3	/* quit */
#define SIGILL		4	/* illegal instruction */
#define SIGTRAP		5	/* trace trap */
#define SIGIOT		6	/* IOT instruction */
#define SIGABRT		SIGIOT  /* Abort (ANSI). */
#define SIGEMT		7	/* EMT instruction */
#define SIGFPE		8	/* floating point exception */
#define SIGKILL		9	/* kill */
#define SIGBUS		10	/* bus error */
#define SIGSEGV		11	/* segmentation violation */
#define SIGSYS		12	/* bad argument in system call */
#define SIGPIPE		13	/* write on a pipe with no reader */
#define SIGALRM		14	/* alarm */
#define SIGTERM		15	/* software termination */
#define SIGURG		16	/* Urgent condition on socket. */
#define SIGSTOP		17	/* Stop, unblockable. */
#define SIGSTP		18	/* Keyboard stop. */
#define SIGCONT		19	/* Continue. */
#define SIGCHLD		20	/* Death of child */
#define SIGCLD		SIGCHLD
#define SIGDIV		21	/* division error */
#define SIGBREAK	22	/* breakpoint */
#define SIGIO		23	/* I/O now possible. */
#define SIGPOLL		SIGIO
#define SIGOVFLW	24	/* integer overflow */
#define SIGBOUND	25	/* BOUND instruction */
#define SIGVTALRM	26	/* Virtual alarm clock */
#define SIGPROF		27	/* Profiling alarm clock */
#define SIGWICH		28	/* Window size change */
#define SIGFPEMU	29	/* floating point emulation */
#define SIGUSR1		30	/* User-defined signal 1 */
#define SIGUSR2		31	/* User-defined signal 2 */

#define _NSIG		32
#define NSIG		_NSIG

typedef void (*SignalHandler) ();

extern SignalHandler signal(int sig, SignalHandler action);

/***
extern SignalHandler sigset(int sig, SignalHandler action);
extern SignalHandler ssignal(int sig, SignalHandler action);
extern int           gsignal (int sig);
***/

extern int           kill (int pid, int sig);

struct sigvec;
extern int           sigsetmask(int mask);

/***
extern int           sigblock(int mask);
extern int           sigpause(int mask);
extern int           sigvec(int sig, struct sigvec* v, struct sigvec* prev);
***/

#define SignalBad	((SignalHandler)-1)
#define SignalDefault	((SignalHandler) 0)
#define SignalIgnore	((SignalHandler) 1)
#define SIG_DFL		SignalDefault
#define SIG_IGN		SignalIgnore
#define SIG_ERR		SignalBad

#endif
