/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#ifndef __DRIVERS_H
#define __DRIVERS_H

#include "\ex32\include\sys\jumper.h"
#include "\ex32\include\sys\message.h"

#define	DEV_NULL		0
#define DEV_MEM			1
#define DEV_TTYS		2
#define DEV_FILES		3
#define DEV_PIPES		4
#define DEV_GR_STANDARD		5
#define DEV_GR_SPECIAL		6
#define DEV_MOUSE		7

#define DEV_LAST		20

#define IO_UNUSED		0
#define IO_DO_BLOCK		1
#define IO_NO_BLOCK		2

#define TRANSFER_BUFFER_SIZE	4096
#define DRIVERS_FILE		"\\ex32\\drivers\\drivers"

#define IRQ_00			0	     	/* timer */
#define IRQ_01			1	     	/* keyboard */
#define IRQ_02			2               /* cascade */
#define IRQ_03			3		/* COM 2 */
#define IRQ_04			4		/* COM 1 */
#define IRQ_05			5		/* unused/mouse */
#define IRQ_06			6		/* floppy disk */
#define IRQ_07			7		/* LPT 1 */

#define IRQ_08			8  		/* real time */
#define IRQ_09			9
#define IRQ_10			10
#define IRQ_11			11
#define IRQ_12			12
#define IRQ_13			13	    	/* coprocessor */
#define IRQ_14			14		/* hard disk */
#define IRQ_15			15

#define IRQ_NONE		255

typedef struct driver_context {
  unsigned char		major;     /* major device number */
  unsigned char		iob;	   /* blocking or non blocking I/O */
  unsigned char		irq;	   /* IRQ attached to driver */
  MESSAGE  *		mb;	   /* message buffer  (DS:mb) */
  char     *		tb;	   /* transfer buffer (DS:tb) */
  MY_JMP_BUF *		ctxb;	   /* context buffer  (DS:ctxb) */
  MY_JMP_BUF		ctx;	   /* driver context */
} DRIVER_CONTEXT;

typedef struct {
  unsigned int		ds;	   /* data segement of irq flags */
  unsigned int		offset;	   /* offset of irq flags */
} IRQ_FLAGS;

typedef struct {
  char 	major [6];
  char  minor [6];
} SPECIAL_REC;

#endif
