/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#ifndef __GRMESS_H
#define __GRMESS_H

#ifdef __TURBOC__
#include <graphics.h>
#else
#include "/ex32/include/graphics.h"
#endif

#define GR_STRLEN		256
#define GR_POLYSIZE		256
#define GR_POLYCOORD		GR_POLYSIZE * 2
#define GR_BITMAPSIZE		4000
#define GR_FILLPATTERN		8

struct palettetype32 {
	unsigned char size;
	signed char colors[MAXCOLORS+1];
};

struct linesettingstype32 {
	long linestyle;
	unsigned long upattern;
	long thickness;
};

struct textsettingstype32 {
	long font;
	long direction;
	long charsize;
	long horiz;
	long vert;
};

struct fillsettingstype32 {
	long pattern;
	long color;
};

struct pointtype32 {
	long x, y;
};

struct viewporttype32 {
	long left, top, right, bottom;
	long clip;
};

struct arccoordstype32 {
	long x, y;
	long xstart, ystart, xend, yend;
};

typedef enum {
	m_arc,				/* 0 */
	m_bar,
	m_bar3d,
	m_circle,
	m_cleardevice,
	m_clearviewport,
	m_closegraph,
	m_detectgraph,
	m_drawpoly,
	m_ellipse,
	m_fillellipse,			/* 10 */
	m_fillpoly,
	m_floodfill,
	m_getarccoords,
	m_getaspectratio,
	m_getbkcolor,
	m_getcolor,
	m_getdefaultpalette,
	m_getdrivername,
	m_getfillpattern,
	m_getfillsettings,		/* 20 */
	m_getgraphmode,
	m_getimage,
	m_getlinesettings,
	m_getmaxcolor,
	m_getmaxmode,
	m_getmaxx,
	m_getmaxy,
	m_getmodename,
	m_getmoderange,
	m_getpalette,			/* 30 */
	m_getpalettesize,
	m_getpixel,
	m_gettextsettings,
	m_getviewsettings,
	m_getx,
	m_gety,
	m_graphdefaults,
	m_grapherrormsg,
/*	m__graphfreemem,*/
/*	m__graphgetmem,*/
	m_graphresult,
	m_imagesize,			/* 40 */
	m_initgraph,
/*	m_installuserdriver,*/
/*	m_installuserfont,*/
	m_line,
	m_linerel,
	m_lineto,
	m_moverel,
	m_moveto,
	m_outtext,
	m_outtextxy,
	m_pieslice,
	m_putimage,			/* 50 */
	m_putpixel,
	m_rectangle,
/*	m_registerbgidriver,*/
/*	m_registerbgifont,*/
	m_restorecrtmode,
	m_sector,
	m_setactivepage,
	m_setallpalette,
	m_setaspectratio,
	m_setbkcolor,
	m_setcolor,
	m_setfillpattern,		/* 60 */
	m_setfillstyle,
/*	m_setgraphbufsize,*/
	m_setgraphmode,
	m_setlinestyle,
	m_setpalette,
	m_setrgbpalette,
	m_settextjustify,
	m_settextstyle,
	m_setusercharsize,
	m_setviewport,
	m_setvisualpage,		/* 70 */
	m_setwritemode,
	m_textheight,
	m_textwidth
} GrMessType;

typedef struct {
  long		x;
  long		y;
  long		stangle;
  long		endangle;
  long		radius;
} Arc;

typedef struct {
  long		left;
  long		top;
  long		right;
  long		bottom;
} Bar;

typedef struct {
  long		left;
  long		top;
  long		right;
  long		bottom;
  long		depth;
  long		topflag;
} Bar3d;

typedef struct {
  long		x;
  long		y;
  long		radius;
} Circle;

typedef struct {
  long		graphdriver;
  long		graphmode;
} Detectgraph;

typedef struct {
  long		numpoints;
  long		polypoints [GR_POLYCOORD];
} Drawpoly;

typedef struct {
  long		x;
  long		y;
  long		stangle;
  long		endangle;
  long		xradius;
  long		yradius;
} Ellipse;

typedef struct {
  long		x;
  long		y;
  long		xradius;
  long		yradius;
} Fillellipse;

typedef struct {
  long		numpoints;
  long		polypoints [GR_POLYCOORD];
} Fillpoly;

typedef struct {
  long		x;
  long		y;
  long		border;
} Floodfill;

typedef struct {
  struct arccoordstype32 arccoords;
} Getarccoords;

typedef struct {
  long		xasp;
  long		yasp;
} Getaspectratio;

typedef struct {
  struct palettetype32 palette;
} Getdefaultpalette;

typedef struct {
  char		drivername [GR_STRLEN];
} Getdrivername;

typedef struct {
  char		pattern [GR_FILLPATTERN];
} Getfillpattern;

typedef struct {
  struct fillsettingstype32 fillinfo;
} Getfillsettings;

typedef struct {
  long		left;
  long		top;
  long		right;
  long		bottom;
  char		bitmap [GR_BITMAPSIZE];
} Getimage;

typedef struct {
  struct linesettingstype32 lineinfo;
} Getlinesettings;

typedef struct {
  long		mode_number;
  char		mode_name [GR_STRLEN];
} Getmodename;

typedef struct {
  long		graphdriver;
  long		lomode;
  long		himode;
} Getmoderange;

typedef struct {
  struct palettetype32 palette;
} Getpalette;

typedef struct {
  long		x;
  long		y;
} Getpixel;

typedef struct {
  struct textsettingstype32 texttypeinfo;
} Gettextsettings;

typedef struct {
  struct viewporttype32 viewport;
} Getviewsettings;

typedef struct {
  long		errorcode;
  char		errormsg [GR_STRLEN];
} Grapherrormsg;

typedef struct {
  long		left;
  long		top;
  long		right;
  long		bottom;
} Imagesize;

typedef struct {
  long		graphdriver;
  long		graphmode;
  char		pathtodriver [GR_STRLEN];
} Initgraph;

typedef struct {
  long		x1;
  long		y1;
  long		x2;
  long		y2;
} Line;

typedef struct {
  long		dx;
  long		dy;
} Linerel;

typedef struct {
  long		x;
  long		y;
} Lineto;

typedef struct {
  long		dx;
  long		dy;
} Moverel;

typedef struct {
  long		x;
  long		y;
} Moveto;

typedef struct {
  char		textstring [GR_STRLEN];
} Outtext;

typedef struct {
  long		x;
  long		y;
  char		textstring [GR_STRLEN];
} Outtextxy;

typedef struct {
  long		x;
  long		y;
  long		stangle;
  long		endangle;
  long		radius;
} Pieslice;

typedef struct {
  long		left;
  long		top;
  char		bitmap [GR_BITMAPSIZE];
  long		op;
} Putimage;

typedef struct {
  long		x;
  long		y;
  long		color;
} Putpixel;

typedef struct {
  long		left;
  long		top;
  long		right;
  long		bottom;
} Rectangle;

typedef struct {
  long		x;
  long		y;
  long		stangle;
  long		endangle;
  long		xradius;
  long		yradius;
} Sector;

typedef struct {
  long		page;
} Setactivepage;

typedef struct {
  struct palettetype32 palette;
} Setallpalette;

typedef struct {
  long		xasp;
  long		yasp;
} Setaspectratio;

typedef struct {
  long		color;
} Setbkcolor;

typedef struct {
  long		color;
} Setcolor;

typedef struct {
  char		upattern [GR_FILLPATTERN];
  long		color;
} Setfillpattern;

typedef struct {
  long		pattern;
  long		color;
} Setfillstyle;

typedef struct {
  long		mode;
} Setgraphmode;

typedef struct {
  long		linestyle;
  long		upattern;
  long		thickness;
} Setlinestyle;

typedef struct {
  long		colornum;
  long		color;
} Setpalette;

typedef struct {
  long		colornum;
  long		red;
  long		green;
  long		blue;
} Setrgbpalette;

typedef struct {
  long		horiz;
  long		vert;
} Settextjustify;

typedef struct {
  long		font;
  long		direction;
  long		charsize;
} Settextstyle;

typedef struct {
  long		multx;
  long		divx;
  long		multy;
  long 		divy;
} Setusercharsize;

typedef struct {
  long		left;
  long		top;
  long		right;
  long		bottom;
  long		clip;
} Setviewport;

typedef struct {
  long		page;
} Setvisualpage;

typedef struct {
  long		mode;
} Setwritemode;

typedef struct {
  char		textstring [GR_STRLEN];
} Textheight;

typedef struct {
  char		textstring [GR_STRLEN];
} Textwidth;

typedef struct {
  long		result;
} Gresult;

typedef union {
  Gresult			gresult_m;
  Arc				arc_m;
  Bar				bar_m;
  Bar3d				bar3d_m;
  Circle			circle_m;
  Detectgraph			detectgraph_m;
  Drawpoly			drawpoly_m;
  Ellipse			ellipse_m;
  Fillellipse			fillellipse_m;
  Fillpoly			fillpoly_m;
  Floodfill			floodfill_m;
  Getarccoords			getarccoords_m;
  Getaspectratio		getaspectratio_m;
  Getdefaultpalette		getdefaultpalette_m;
  Getdrivername			getdrivername_m;
  Getfillpattern		getfillpattern_m;
  Getfillsettings		getfillsettings_m;
  Getimage			getimage_m;
  Getlinesettings		getlinesettings_m;
  Getmodename			getmodename_m;
  Getmoderange			getmoderange_m;
  Getpalette			getpalette_m;
  Getpixel			getpixel_m;
  Gettextsettings		gettextsettings_m;
  Getviewsettings		getviewsettings_m;
  Grapherrormsg			grapherrormsg_m;
  Imagesize			imagesize_m;
  Initgraph			initgraph_m;
  Line				line_m;
  Linerel			linerel_m;
  Lineto			lineto_m;
  Moverel			moverel_m;
  Moveto			moveto_m;
  Outtext			outtext_m;
  Outtextxy			outtextxy_m;
  Pieslice			pieslice_m;
  Putimage			putimage_m;
  Putpixel			putpixel_m;
  Rectangle			rectangle_m;
  Sector			sector_m;
  Setactivepage			setactivepage_m;
  Setallpalette			setallpalette_m;
  Setaspectratio		setaspectratio_m;
  Setbkcolor			setbkcolor_m;
  Setcolor			setcolor_m;
  Setfillpattern		setfillpattern_m;
  Setfillstyle			setfillstyle_m;
  Setgraphmode			setgraphmode_m;
  Setlinestyle			setlinestyle_m;
  Setpalette			setpalette_m;
  Setrgbpalette			setrgbpalette_m;
  Settextjustify		settextjustify_m;
  Settextstyle			settextstyle_m;
  Setusercharsize		setusercharsize_m;
  Setviewport			setviewport_m;
  Setvisualpage			setvisualpage_m;
  Setwritemode			setwritemode_m;
  Textheight			textheight_m;
  Textwidth			textwidth_m;
} Graphic_Mess;

extern int send_grmess (GrMessType, Graphic_Mess *);
extern int recv_grmess (GrMessType, Graphic_Mess *);
extern int sendrecv_grmess (GrMessType, Graphic_Mess *);

#endif
