/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#ifndef __GRXMESS_H
#define __GRXMESS_H

#include "grx.h"

typedef enum {
	m_GrSetMode,			/* 0 */
	m_GrLine
} GrxMessType;

typedef struct {
  long		which;
  long		width;
  long		height;
  long		colors;
} p_GrSetMode;

typedef struct {
  long		x1;
  long		y1;
  long		x2;
  long		y2;
  long		c;
} p_GrLine;

typedef union {
  p_GrSetMode			GrSetMode_m;
  p_GrLine			GrLine_m;
} Grx_Mess;

extern int send_grmess (GrxMessType, Grx_Mess *);
extern int recv_grmess (GrxMessType, Grx_Mess *);
extern int sendrecv_grmess (GrxMessType, Grx_Mess *);

#endif
