/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#ifndef __MESSAGE_H
#define __MESSAGE_H

typedef unsigned char      byte;
typedef unsigned short int word16;
typedef unsigned long int  word32;

typedef enum {
  m_intr,
  m_open,
  m_close,
  m_read,
  m_write,
  m_wrrd,
  m_lseek,
  m_unlink,
  m_rename,
  m_access,
  m_chmod,
  m_setmode,
  m_fstat,
  m_stat,
  m_isatty,
  m_fork,
  m_execve,
  m_wait,
  m_exit,
  m_brk,
  m_signal,
  m_kill,
  m_sighand,
  m_sigmask,
  m_procjmp,
  m_procget,
  m_proccpy,
  m_getpid,
  m_getgid,
  m_setpgrp,
  m_gettimeofday,
  m_settimeofday,
  m_mknod,
  m_chdir,
  m_pipe,
  m_dup,
  m_link,
  m_fcntl,
  m_return,
  m_breakpoint,
  m_getcwd,
  m_dossys
} Messages;

/* Note: The following structure is used to change the register context
 * of a process. It is allowed to change just the lower 8 bits (carry flag,
 * parity flag, auxiliary flag, zero flag and sign flag) of the EFLAGS
 * register.
 */

typedef struct {
  word32	eax;	/* 0 */
  word32	ebx;	/* 1 */
  word32	ecx;	/* 2 */
  word32	edx;	/* 3 */
  word32	esi;	/* 4 */
  word32	edi;	/* 5 */
  word32	ebp;	/* 6 */
  word32	esp;	/* 7 */
  word32	eip;	/* 8 */
  word32	eflags;	/* 9 */
} REGS;

typedef struct {
  word32	filename;	/* 32 bit address of filename */
  long		name_len;	/* length of filename */
  word32	flag;
  word32        mode;
} Open_Mess;

typedef struct {
  long		filedes;
} Close_Mess;

typedef struct {
  long   	filedes;
  word32 	buffer;
  word32   	size;
} Read_Mess;

typedef struct {
  long   	filedes;
  word32 	buffer;
  word32   	size;
} Write_Mess;

typedef struct {
  long		filedes;
  word32	buffer;
  word32	size;
} WrRd_Mess;

typedef struct {
  long 		filedes;
  long 		offset;
  long 		fromwhere;
} Lseek_Mess;

typedef struct {
  word32	filename;
  long		name_len;
} Unlink_Mess;

typedef struct {
  word32	oldname;
  long		old_len;
  word32	newname;
  long		new_len;
} Rename_Mess;

typedef struct {
  word32	filename;
  long		name_len;
  long		mode;
} Access_Mess;

typedef struct {
  word32	filename;
  long		name_len;
  long		mode;
} Chmod_Mess;

typedef struct {
  long 		filedes;
  long		amode;
} Setmode_Mess;

typedef struct {
  long		filedes;
  word32	statbuf;
} Fstat_Mess;

typedef struct {
  word32	filename;
  long		name_len;
  word32	statbuf;
} Stat_Mess;

typedef struct {
  long		filedes;
} Isatty_Mess;

typedef struct {
  long		kind;
} Fork_Mess;

typedef struct {
  word32	filename;
  long		name_len;
  long		argc;
  word32	argv;
  long		argv_len;
  long		envc;
  word32	envp;
  long		envp_len;
  word32	ex_flags;
} Execve_Mess;

typedef struct {
  long		status;
} Wait_Mess;

typedef struct {
  long		status;
} Exit_Mess;

typedef struct {
  long		pid;
  long		brksize;
} Brk_Mess;

typedef struct {
  REGS		regs;
} Signal_Mess;

typedef struct {
  long		pid;
  long		signal;
} Kill_Mess;

typedef struct {
  word32	handler;
} Sighand_Mess;

typedef struct {
  long		mask;
} Sigmask_Mess;

typedef struct {
  long		pid;
  REGS		regs;
} Procjmp_Mess;

typedef struct {
  long		pid;
  REGS		regs;
} Procget_Mess;

typedef struct {
  long		from_pid;
  long		to_pid;
  word32	src_buf;
  word32	dest_buf;
  long		size;
} Proccpy_Mess;

typedef struct {
  word32	timeval;
  word32	timezone;
} Gettimeofday_Mess;

typedef struct {
  word32	timeval;
  word32	timezone;
} Settimeofday_Mess;

typedef struct {
  word32	filename;
  long		name_len;
  long		modes;
  long		dev;
} Mknod_Mess;

typedef struct {
  word32	dirname;
  long		name_len;
} Chdir_Mess;

typedef struct {
  long		read_end;
  long		write_end;
} Pipe_Mess;

typedef struct {
  long		oldfd;
  long		newfd;
  long		type;
} Dup_Mess;

typedef struct {
  word32	file1;
  long		name_len1;
  word32	file2;
  long		name_len2;
  long		type;
} Link_Mess;

typedef struct {
  long		filedes;
  long		cmd;
  long		arg;
} Fcntl_Mess;

typedef struct {
  long		pid;
  long		cmd;
  word32	addr;
} Breakpoint_Mess;

typedef struct {
  word32	path;
  long		path_len;
} Getcwd_Mess;

typedef struct {
  word32	string;
  long		str_len;
} Dossys_Mess;

typedef struct {
  long     	 	type;
  long     	 	result;
  long         		errno;
  union {
    Open_Mess    	open_m;
    Close_Mess   	close_m;
    Read_Mess    	read_m;
    Write_Mess   	write_m;
    WrRd_Mess		wrrd_m;
    Lseek_Mess   	lseek_m;
    Unlink_Mess	 	unlink_m;
    Rename_Mess		rename_m;
    Access_Mess	 	access_m;
    Chmod_Mess	 	chmod_m;
    Setmode_Mess 	setmode_m;
    Fstat_Mess	 	fstat_m;
    Stat_Mess	 	stat_m;
    Isatty_Mess	 	isatty_m;
    Fork_Mess		fork_m;
    Execve_Mess	 	execve_m;
    Exit_Mess	 	exit_m;
    Wait_Mess    	wait_m;
    Brk_Mess	 	brk_m;
    Signal_Mess	 	signal_m;
    Kill_Mess	 	kill_m;
    Sighand_Mess 	sighand_m;
    Sigmask_Mess 	sigmask_m;
    Procjmp_Mess 	procjmp_m;
    Procget_Mess 	procget_m;
    Proccpy_Mess 	proccpy_m;
    Gettimeofday_Mess	gettimeofday_m;
    Settimeofday_Mess	settimeofday_m;
    Mknod_Mess		mknod_m;
    Chdir_Mess		chdir_m;
    Pipe_Mess		pipe_m;
    Dup_Mess		dup_m;
    Link_Mess		link_m;
    Fcntl_Mess		fcntl_m;
    Breakpoint_Mess	breakpoint_m;
    Getcwd_Mess		getcwd_m;
    Dossys_Mess		dossys_m;
  } m;
} MESSAGE;

extern long call_system (MESSAGE *);
extern long messsubtype (long);
extern long sizeofmess (Messages);

#endif
