/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#ifndef __SYSCALLS_H
#define __SYSCALLS_H

#include <stdio.h>
#include <std.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/message.h>
#include <sys/time.h>
#include <sigaction.h>

#define EXEC_NORMAL		0
#define EXEC_EMU		1
#define EXEC_DEBUG		2

extern int	_open	(const char * filename, int flag, ...);
extern int	_close	(int filedes);
extern int	_read	(int filedes, void * buffer, unsigned size);
extern int	_write	(int filedes, const void * buffer, unsigned size);
extern int	_wrrd	(int filedes, void * buffer, unsigned size);
extern long	_lseek	(int filedes, long offset, int fromwhere);
extern int	_unlink	(const char * filename);
extern int	_access	(const char * filename, int mode);
extern int	_chmod	(const char * filename, int mode);
extern int	_setmode(int filedes, int amode);
extern int	_fstat	(int filedes, struct stat * statbuf);
extern int	_stat	(const char * filename, struct stat * statbuf);
extern int	_isatty	(int filedes);
extern int	_rename	(const char * oldname, const char * newname);
extern char *	_getcwd (char * path, int pathlen);

extern int	_fork	(void);
extern int	_vfork	(void);
extern int	_execve	(const char * filename, 
                         const char ** argv, 
			 char ** envp);
extern int	_setexec(int mask);			 
extern int	_wait	(int * status);
extern void	_exit	(int status);

extern int	_procjmp (int pid, REGS regs);
extern int	_procget (int pid, REGS * regs);
extern int	_proccpy (int from_pid, int to_pid, 
                         void * src_buf, void * dest_buf, 
			 long size);
extern int	_breakpoint (int pid, int cmd, unsigned addr);

extern int	__brk	(int pid, void * end_data_seg);
extern int	_brk	(void * end_data_seg);
extern void *	__sbrk	(int pid, int sbrk_value);
extern void *	_sbrk	(int sbrk_value);

extern int		_kill		(int pid, int sig);
extern SignalHandler	_signal		(int sig, SignalHandler handler);
extern int		_sigsetmask	(int mask);
extern int		_sigaction 	(int sig,
					 struct sigaction * act,
					 struct sigaction * oact);

extern int	_getpid	(void);
extern int	_getgid	(void);
extern int	_setpgrp (void);
extern int	_getpagesize (void);
extern int	_getdtablesize (void);

extern int	_gettimeofday (struct timeval * tv, struct timezone * tz);
extern int	_settimeofday (struct timeval * tv, struct timezone * tz);

extern int	_mknod	(const char * filename, int modes, int dev);
extern int	_chdir	(const char * dir);
extern int	_pipe	(int * filedes);
extern int	_dup	(int filedes);
extern int	_dup2	(int oldfd, int newfd);
extern int	_link	(const char * file1, const char * file2);
extern int	_symlink(const char * file1, const char * file2);
extern int	_fcntl	(int filedes, int cmd, ...);

extern int	_dossys	(char * string);

#endif
