/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#ifndef _SYS_TIME_H_
#define _SYS_TIME_H_

#include <time.h>

#define DST_NONE		0   /* not on dst */

#define DST_USA   		1;  /* USA style dst */
#define DST_AUST  		2;  /* Australian style dst */
#define DST_WET   		3;  /* Western European dst */
#define DST_MET   		4;  /* Middle European dst */
#define DST_EET   		5;  /* Eastern European dst */

struct timeval {
  long		tv_sec;          /* seconds */
  long		tv_usec;         /* and microseconds */
};


struct timezone {
  int		tz_minuteswest;	/* minutes west of Greenwich */
  int		tz_dsttime;	/* type of dst correction */
};

struct itimerval {
  struct timeval	it_interval;	/* timer inverval */
  struct timeval	it_value;	/* current value */
};
/***
struct tm {
  int		tm_sec;		/* seconds (0 - 59) * /
  int		tm_min;		/* minutes (0 - 59) * /
  int		tm_hour;	/* hours (0 - 23) * /
  int		tm_mday;	/* day of month (1 - 31) * /
  int		tm_mon;		/* month of year (0 - 11) * /
  int		tm_year;	/* year - 1900 * /
  int		tm_wday;	/* day of week (Sunday = 0) * /
  int		tm_yday;	/* day of year (0 - 365) * /
  int		tm_isdst;	/* daylight savings time flag * /
};
***/
struct tms {
  long		tms_utime;	/* user time */
  long		tms_stime;	/* system time */
  long		tms_cutime;	/* user time, children */
  long		tms_cstime;	/* system time, children */
};

struct timeb {
  long			time;
  unsigned short	millitm;
  short			timezone;
  short			dstflag;
};

extern int	gettimeofday (struct timeval *, struct timezone *);
extern int	settimeofday (struct timeval *, struct timezone *);

extern int	adjtime (struct timeval *, struct timeval *);

#define ITIMER_REAL     	0   /* real time intervals */
#define ITIMER_VIRTUAL  	1   /* virtual time intervals */
#define ITIMER_PROF     	2   /* user and system virtual time */

extern int	getitimer (int, struct itimerval *);
extern int	setitimer (int, struct itimerval *, struct itimerval *);

extern int	stime (long *);
extern long	clock (void);
extern long	times (struct tms *);
extern void	ftime (struct timeb *);
/***
extern unsigned long	time (unsigned long *);
extern char *		ctime (long *);
extern struct tm *	localtime (long *);
extern struct tm *	gmtime (long *);
extern char *		asctime (struct tm *);
***/
#endif
