/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <std.h>
#include <time.h>
#include <errno.h>
#include <pwd.h>
#include <grp.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <utime.h>
#include <sys/mknod.h>

#define PATHLEN			1024
#define BUFSIZE			30

extern char ** environ;
extern int errno;

static char gr_name [] = "system";
static char pw_name [] = "root";
static char pw_passwd [] = "password";
static char pw_dir [] = "/ex32/bin";
static char pw_shell [] = "/ex32/bin/vssh";
static struct passwd pwd;
static struct group  grp;

static char buffer [BUFSIZE];

char * getlogin (void)
  {
    return pw_name;
  }

struct group * getgrgid (unsigned int gid)
  {
    grp.gr_name   = gr_name;
    grp.gr_passwd = pw_passwd;
    grp.gr_gid    = 0;
    grp.gr_mem    = 0;
    return &grp;
  }

struct group * getgrnam (char * name)
  {
    grp.gr_name   = gr_name;
    grp.gr_passwd = pw_passwd;
    grp.gr_gid    = 0;
    grp.gr_mem    = 0;
    return &grp;
  }
  
/****  
char * ctime (const time_t * t)
  {
    sprintf (buffer, "%ld", t);
    return buffer;
  }

struct tm * localtime(timep)
  const time_t * const	timep;
{
	static struct tm	tm;
	return &tm;
}
***/
 
int getloadavg (double * avg, int i)
  {
    errno = EZERO;			/* means not supported */
    return -1;
  }

int geteuid (void)
  {
    return 0;
  }
  
int getegid (void)
  {
    return 0;
  }

int getuid (void)
  {
    return 0;
  }


struct passwd * getpwnam (char * name)
  {
    pwd.pw_name    = pw_name;
    pwd.pw_passwd  = pw_passwd;
    pwd.pw_uid	   = 0;
    pwd.pad0	   = 0;
    pwd.pw_gid     = 0;
    pwd.pad1       = 0;
    pwd.pw_comment = 0;
    pwd.pw_gecos   = 0;
    pwd.pw_dir	   = pw_dir;
    pwd.pw_shell   = pw_shell;
    return &pwd;    
  }
  
struct passwd * getpwuid (int uid)
  {
    return getpwnam (0);
  }

char * getwd (char * wd)
  {
    return getcwd (wd, PATHLEN);
  }

int select ()
  {
    return 0;
  }

#define NAME_LEN		256
static char subpath [NAME_LEN];

char * searchpath (char * path, char * name)
  {
    int i = 0, j, len; struct stat statbuf;
    
    if (stat (name, &statbuf) >= 0) {   /* check "." */
      return name;
    }
    len  = strlen (path);
    while (i < len) {
      j = 0;
      while ((i < len) && (path [i] != ';')) {
        subpath [j++] = path [i++];
	subpath [j]   = '\0';
      }
      strcat (subpath, "/");
      strcat (subpath, name);
      if (stat (subpath, &statbuf) >= 0) {
	return subpath;
      }
      i++;		/* skip ';' */
    }
    return 0;
  }


int execvp (const char * name, const char ** argv)
  {
    char * path; char * f_name;
    path = getenv ("PATH");
    if ((f_name = searchpath (path, (char *) name)) != 0) {
      return execve (f_name, argv, environ);
    }
    return -1;
  }

int setitimer ()
  {
    return 0;
  }

int umask (int mask)
  {
    return 0644;
  }
  
int chown (const char * path, int id1, int id2)
  {
    return 0;
  }

#define my_feof(p)		feof(p)
#undef feof

int feof (FILE * f)
  {
    return my_feof (f);
  }

#define my_getc(p)		getc(p)
#undef getc

int getc (FILE * f)
  {
    return my_getc (f);
  }
  
#define my_putc(c,p)		putc(c,p)
#undef putc

int putc (int c, FILE * f)
  {
    return my_putc (c, f);
  }

int fsync (int fd)
  {
    return 0;
  }
  
int mkdir (const char * path, int mode)
  {
    return mknod (path, MKN_DIR, mode);
  }
  
int rmdir (const char * path)
  {
    return unlink (path);
  }

int readlink (const char * path, char * link, int i)
  {
    errno = ENOSYS;
    return -1;
  }

int utime (const char * file, const struct utimbuf * times)
  {
     char ch; int fd;
     if (times == NULL) {
       if ((fd = open (file, O_RDWR | O_BINARY, 0)) < 0) {
         return -1;
       }
       close (fd);
       return 0;
     } else {
       return -1;
     }
  }

int utimes (const char * file, const struct utimbuf * times)
  {
    return utime (file, times);
  }

int waitpid (int pid, int * status, int flags)
  {
    return wait (status);
  }

