/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <std.h>
#include <stdio.h>

#define NAME_LEN	60
#define ARGCOUNT	500

static int process_command (const char * command, 
                            char args [ARGCOUNT] [NAME_LEN])
  {
    int i = 0, j, k = 0, len;
    
    len = strlen (command);
    while ((i < ARGCOUNT - 1) && (k < len)) {
      while ((k < len) && (command [k] == ' ')) {	/* skip blanks */
	k++;
      }
      if (k >= len) {
        break;
      }

      j = 0;
      while ((k < len) && (j < NAME_LEN - 1) && (command [k] != ' ')) {  
        args [i] [j] = command [k];		/* argument found */
	j++; k++;
	args [i] [j] = '\0';
      }
	
      if (args [i] [0] == '@') {		/* argument file */
        FILE * file; char ch;
	
	if ((file = fopen (&args [i] [1], "r")) != NULL) {
	  ch = fgetc (file);
	  while (ch != EOF) {
	    while ((ch == ' ') || (ch == '\n')) {
	      ch = fgetc (file);
	    }
	    if (ch == EOF) {
	      break;
	    }
	    j = 0;    
	    while ((ch != EOF) && (j < NAME_LEN - 1) &&
	           (ch != ' ') && (ch != '\n')) {
	      args [i] [j] = ch;
	      j++;
	      args [i] [j] = '\0';
	      ch = fgetc (file);
	    }
	    i++;
	  }
	  fclose (file);
	}
      } else {
        i++;
      }
    }
    return i;
  }

int system (const char * command)
  {
    int status, cnt, i = 0;
    char args [ARGCOUNT] [NAME_LEN];
    char * argv [ARGCOUNT];
    
    cnt = process_command (command, args);
    argv [0] = 0;
    while (i < cnt) {
      argv [i] = &args [i] [0];
      i++;
      argv [i] = 0;
    }

    if (vfork () == 0) {
      /* child */
      if (execve (args [0], (const char **) argv, environ) < 0) {
        exit (-1);
      }
      /* never reached */
    }
    /* parent */
    wait (&status);
    return status;
  }
