/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <std.h>
#include <sys/stat.h>
#include <setjmp.h>
#include <signal.h>
#include <sigaction.h>
#include <sys/syscalls.h>
#include <sys/time.h>

int access (const char * filename, int mode)
  {
    return _access (filename, mode);
  }

int brk (void * end_data_seg)
  {
    return _brk (end_data_seg);
  }

int chdir (const char * dir)
  {
    return _chdir (dir);
  }

int chmod (const char * filename, int mode)
  {
    return _chmod (filename, mode);
  }

int close (int filedes)
  {
    return _close (filedes);
  }

int dossys (char * string)
  {
    return _dossys (string);
  }

int dup (int filedes)
  {
    return _dup (filedes);
  }

int dup2 (int oldfd, int newfd)
  {
    return _dup2 (oldfd, newfd);
  }

int execve (const char * filename, const char ** argv, char ** envp)
  {
    return _execve (filename, argv, envp);
  }

int fcntl (int filedes, int cmd, ...)
  {
    int * arg_addr = &cmd + 1;
    return _fcntl (filedes, cmd, *arg_addr);
  }

int fork (void)
  {
    return _fork ();
  }

int fstat (int filedes, struct stat * statbuf)
  {
    return _fstat (filedes, statbuf);
  }

char * getcwd (char * path, int pathlen)
  {
    return _getcwd (path, pathlen);
  }

int getdtablesize (void)
  {
    return _getdtablesize ();
  }

int getgid (void)
  {
    return _getgid ();
  }

int getpagesize (void)
  {
    return _getpagesize ();
  }

int getpid (void)
  {
    return _getpid ();
  }

int gettimeofday (struct timeval * tv, struct timezone * tz)
  {
    return _gettimeofday (tv, tz);
  }

int isatty (int filedes)
  {
    return _isatty (filedes);
  }

int kill (int pid, int size)
  {
    return _kill (pid, size);
  }

int link (const char * file1, const char * file2)
  {
    return _link (file1, file2);
  }

void longjmp (jmp_buf buf, int val)
  {
    _longjmp (buf, val);
  }

long lseek (int filedes, long offset, int fromwhere)
  {
    return _lseek (filedes, offset, fromwhere);
  }

int mknod (const char * filename, int modes, int dev)
  {
    return _mknod (filename, modes, dev);
  }
  
int open (const char * filename, int flag, ...)
  {
    int * mode_addr = &flag + 1; 
    return _open (filename, flag, *mode_addr);
  }

int pipe (int * filedes)
  {
    return _pipe (filedes);
  }

int read (int filedes, void * buffer, unsigned size)
  {
    return _read (filedes, buffer, size);
  }

int rename (const char * oldname, const char * newname)
  {
    return _rename (oldname, newname);
  }

void * sbrk (int sbrk_value)
  {
    return _sbrk (sbrk_value);
  }

int setpgrp (void)
  {
    return _setpgrp ();
  }

int settimeofday (struct timeval * tv, struct timezone * tz)
  {
    return _settimeofday (tv, tz);
  }

int sigsetmask (int mask)
  {
    return _sigsetmask (mask);
  }

SignalHandler signal (int sig, SignalHandler handler)
  {
    return _signal (sig, handler);
  }

int stat (const char * filename, struct stat * statbuf)
  {
    return _stat (filename, statbuf);
  }

int symlink (const char * file1, const char * file2)
  {
    return _symlink (file1, file2);
  }

int unlink (const char * filename)
  {
    return _unlink (filename);
  }

int vfork (void)
  {
    return _vfork ();
  }
  
int wait (int * status)
  {
    return _wait (status);
  }  
  
int write (int filedes, const void * buffer, unsigned size)
  {
    return _write (filedes, buffer, size);
  }

int sigaction (int sig, struct sigaction * act, struct sigaction * oact)
  {
    return _sigaction (sig, act, oact);
  }
