/* "@(#)$Header: getpass.c,v 1.0 92/02/10 12:07:30 ericb Rel $" */

/*
  (c) Copyright 1992 Eric Backus

  This software may be used freely so long as this copyright notice is
  left intact.  There is no warrantee on this software.
*/

#include <stdio.h>
#include <stdlib.h>	/* For exit() */
/* #include <pc.h>	*/	/* For getkey() */

/* This is superior to the standard getpass(), because it doesn't
   overwrite previous calls and allows for passwords of any length. */
int
getlongpass(const char *prompt, char *password, int max_length)
{
    char	*p = password;
    int		c, count = 0;

    /* If we can't prompt, abort */
    if (fputs(prompt, stderr) < 0)
    {
	*p = '\0';
	return -1;
    }

    while (1)
    {
	/* Get a character with no echo */
	c = getkey();

	/* Exit on interrupt (^c or ^break) */
	if (c == '\003' || c == 0x100) exit(1);

	/* Terminate on end of line or file (^j, ^m, ^d, ^z) */
	if (c == '\r' || c == '\n' || c == '\004' || c == '\032')
	    break;

	/* Back up on backspace */
	if (c == '\b')
	{
	    if (count) count--;
	    else if (p > password) p--;
	    continue;
	}

	/* Ignore DOS extended characters */
	if ((c & 0xff) != c) continue;

	/* Add to password if it isn't full */
	if (p < password + max_length - 1)
	    *p++ = c;
	else
	    count++;
    }
    *p = '\0';

    (void) fputc('\n', stderr);

    return 0;
}

/* UNIX compatible getpass().  Returns a pointer to a null-terminated
   static buffer of at most eight characters. */
char *
getpass(const char *prompt)
{
    static char		password_buffer[9];

    if (getlongpass(prompt, password_buffer, 9) < 0)
	return (char *) NULL;
    return password_buffer;
}

