/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

/* Note: The values given to and returned by brk () are relative to
 * the used memory model !
 * brk () sets the highest address of a process's data region to
 * end_data_seg. If brk () is called with -1 the current highest
 * address of the data region is returned (and nothing is changed).
 * If brk () is called with -2 the current highest address of the
 * text region is returned. It is not possible to change the size of
 * a process's text region. brk () is used for sbrk (). The argument
 * of brk () must be in the range (-2 >= end_data_seg <= possible
 * amount of memory for a process). If the argument is valid brk ()
 * returns the old brk value otherwise -1.
 */

#include <sys/syscalls.h>
#include <sys/message.h>

extern int __pid;

int __brk (int pid, void * end_data_seg)
  {
    MESSAGE mess;
    mess.type = m_brk;
    mess.m.brk_m.pid     = pid;
    mess.m.brk_m.brksize = (long) end_data_seg;
    return call_system (&mess);
  }

int _brk (void * end_data_seg)
  {
    return __brk (__pid, end_data_seg);
  }
