/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <sys/syscalls.h>
#include <sys/message.h>

#define	DUP_TYPE_0		0
#define DUP_TYPE_2		1

int _dup (int filedes)
  {
    MESSAGE mess;
    mess.type = m_dup;
    mess.m.dup_m.oldfd = filedes;
    mess.m.dup_m.newfd = -1;
    mess.m.dup_m.type  = DUP_TYPE_0;
    return call_system (&mess);
  }

int _dup2 (int oldfd, int newfd)
  {
    MESSAGE mess;
    mess.type = m_dup;
    mess.m.dup_m.oldfd = oldfd;
    mess.m.dup_m.newfd = newfd;
    mess.m.dup_m.type  = DUP_TYPE_2;
    return call_system (&mess);
  }
