/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <sys/syscalls.h>
#include <sys/message.h>

static int exec_flags = EXEC_NORMAL;

int _execve (const char * filename, const char ** argv, char ** envp)
  {
    MESSAGE mess;
    int argc = 0, argvlen = 0, envc = 0, envplen = 0, namelen = 0;
    
    namelen = strlen (filename) + 1;
    if (argv != 0) {
      while (argv [argc] != 0) {
        argvlen = argvlen + strlen (argv [argc]) + 1;
        argc++;
      }
    }
    if (envp != 0) {
      while (envp [envc] != 0) {
        envplen = envplen + strlen (envp [envc]) + 1;
        envc++;
      }
    }
    mess.type = m_execve;
    mess.m.execve_m.filename = (word32) filename;
    mess.m.execve_m.name_len = namelen;
    mess.m.execve_m.argc     = argc;
    mess.m.execve_m.argv     = (word32) argv;
    mess.m.execve_m.argv_len = argvlen;
    mess.m.execve_m.envc     = envc;
    mess.m.execve_m.envp     = (word32) envp;
    mess.m.execve_m.envp_len = envplen;
    mess.m.execve_m.ex_flags = exec_flags;
    exec_flags = EXEC_NORMAL;			/* reset exec flag */
    return call_system (&mess);
  }

int _setexec (int mask)
  {
    int old_val;
    old_val = exec_flags;
    exec_flags = mask;
    return old_val;
  }  
