/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <sys/syscalls.h>
#include <sys/message.h>

#define LINK_TYPE_NORMAL		0
#define LINK_TYPE_SYMBOLIC		1

int _link (const char * file1, const char * file2)
  {
    MESSAGE mess;
    mess.type = m_link;
    mess.m.link_m.file1     = (word32) file1;
    mess.m.link_m.name_len1 = strlen (file1) + 1;
    mess.m.link_m.file2	    = (word32) file2;
    mess.m.link_m.name_len2 = strlen (file2) + 1;
    mess.m.link_m.type      = LINK_TYPE_NORMAL;
    return call_system (&mess);
  }

int _symlink (const char * file1, const char * file2)
  {
    MESSAGE mess;
    mess.type = m_link;
    mess.m.link_m.file1     = (word32) file1;
    mess.m.link_m.name_len1 = strlen (file1) + 1;
    mess.m.link_m.file2	    = (word32) file2;
    mess.m.link_m.name_len2 = strlen (file2) + 1;
    mess.m.link_m.type      = LINK_TYPE_SYMBOLIC;
    return call_system (&mess);
  }
