/* This is file LONGJMP.S */
/*
** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

/*
**	jmp_buf:
**	 eax ebx ecx edx esi edi ebp esp eip
**	 0   4   8   12  16  20  24  28  32
*/

	.globl	__longjmp /* jmp_buf, int */
__longjmp:
	pushl	%ebp
	movl	%esp,%ebp

	movl	8(%ebp),%edi	/* edi = jmp_buf */
	movl	12(%ebp),%eax	/* eax = retval */
	cmpl	$0, %eax	/* eax == 0 ? */
	jne	ret_ok
	movl	$1, %eax	/* eax = 1 */
ret_ok:	
	movl	%eax,0(%edi)	/* jmp_buf [0].eax = eax */

	movl	24(%edi),%ebp	/* ebp = jmp_buf [0].ebp */

/***	cli		code executed at priviledge level 3 ***/
	movl	28(%edi),%esp	/* esp = jmp_buf [0].esp */
	
	pushl	32(%edi)	/* push jmp_buf [0].eip */

	movl	0(%edi),%eax	/* eax = jmp_buf [0].eax */
	movl	4(%edi),%ebx	/* ebx = jmp_buf [0].ebx */
	movl	8(%edi),%ecx	/* ecx = jmp_buf [0].ecx */
	movl	12(%edi),%edx	/* edx = jmp_buf [0].edx */
	movl	16(%edi),%esi	/* esi = jmp_buf [0].esi */
	movl	20(%edi),%edi	/* edi = jmp_buf [0].edi */
/***	sti		code executed at priviledge level 3 ***/

	ret			/* actually jump to new eip */
