/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <sys/types.h>
#include <sys/message.h>

int errno;

static struct {
  word32	 offset;
  unsigned short selector;
} jumper;
static word32 address_1, address_2;
static long mess_subtype = 0;

long messsubtype (long subtype)
  {
    long oldval = mess_subtype;
    mess_subtype = subtype;
    return oldval;
  }

long call_system (MESSAGE * message)
  {
    /* In this procedure we call the system. The system task resides in
     * GDT [3] - its GDT selector has the value (3 << 3) = 24 = 0x18.
     * The system task is called via a indirect jump. The address for
     * the jump is stored in jumper (ljmp 0x0018:0x00000000).
     */
    message->result = mess_subtype;	/* set message subtype */
    jumper.offset   = 0;		/* offset of jump is 0x00000000 */
    jumper.selector = 0x18;		/* the selector is 0x0018 */
    address_1 = (word32) message;
    address_2 = (word32) &jumper;
    asm ("pushl %eax");
    asm ("pushl %ebx");
    asm ("movl _address_1, %eax");	/* move address of message into eax  */
    asm ("movl _address_2, %ebx");	/* move address of jumper into ebx   */
    asm ("ljmp (%ebx)");		/* here we go - jump to system task  */
    asm ("popl %ebx");
    asm ("popl %eax");
    errno = message->errno;		/* set errno for last system call    */
    return message->result;		/* result was set by the system task */
  }
