/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <sys/syscalls.h>
#include <sys/message.h>

int _procjmp (int pid, REGS regs)
  {
    MESSAGE mess;
    mess.type = m_procjmp;
    mess.m.procjmp_m.pid  = pid;
    mess.m.procjmp_m.regs = regs;
    return call_system (&mess);
  }
  
int _procget (int pid, REGS * regs)
  {
    MESSAGE mess; int result;
    mess.type = m_procget;
    mess.m.procget_m.pid = pid;
    result = call_system (&mess);
    * regs = mess.m.procget_m.regs;
    return result;
  }
 
int _proccpy (int from_pid, int to_pid, 
              void * src_buf, void * dest_buf, 
	      long size)
  {
    MESSAGE mess;
    
    mess.type = m_proccpy;
    mess.m.proccpy_m.from_pid = from_pid;
    mess.m.proccpy_m.to_pid   = to_pid;
    mess.m.proccpy_m.src_buf  = (word32) src_buf;
    mess.m.proccpy_m.dest_buf = (word32) dest_buf;
    mess.m.proccpy_m.size     = size;
    return call_system (&mess);
  }

int _breakpoint (int pid, int cmd, unsigned addr)
  {
    MESSAGE mess;
    
    mess.type = m_breakpoint;
    mess.m.breakpoint_m.pid  = pid;
    mess.m.breakpoint_m.cmd  = cmd;
    mess.m.breakpoint_m.addr = addr;
    return call_system (&mess);
  }
