/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <sys/syscalls.h>

static void setup_data_seg ()
  {
    /* Set last address of data segment to one 
     * where the last 3 bits are 0. This is necessary
     * for some storage allocators to work correctly.
     */
    int result, old_size = _brk ((char *) -1);
    result = _brk ((char *) ((old_size + 7) & ~7));
    if (result != old_size) {
      _exit (-1);
    }
  }

void * __sbrk (int pid, int sbrk_value)
  {
    int old_size, result;
    old_size = __brk (pid, (char *) -1);
    result = __brk (pid, (char *) (old_size + sbrk_value));
    return (void *) result;
  }

void * _sbrk (int sbrk_value)
  {
    int old_size, result;
    /*setup_data_seg ();*/
    old_size = brk ((char *) -1);
    result = brk ((char *) (old_size + sbrk_value));
    return (void *) result;
  }
