/* This is file SETJMP.S */
/*
** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

/*
**	jmp_buf:
**	 eax ebx ecx edx esi edi ebp esp eip
**	 0   4   8   12  16  20  24  28  32
*/

	.globl	_setjmp /* jmp_buf */
_setjmp:
	.globl  __setjmp
__setjmp:
	pushl	%ebp
	movl	%esp,%ebp

	pushl	%edi		/* push edi */
	movl	8(%ebp),%edi	/* edi = &jmp_buf [0] */

	movl	%eax,0(%edi)	/* jmp_buf [0].eax = eax */
	movl	%ebx,4(%edi)	/* jmp_buf [0].ebx = ebx */
	movl	%ecx,8(%edi)	/* jmp_buf [0].ecx = ecx */
	movl	%edx,12(%edi)	/* jmp_buf [0].edx = edx */
	movl	%esi,16(%edi)	/* jmp_buf [0].esi = esi */

	movl	-4(%ebp),%eax	/* eax = pushed edi */
	movl	%eax,20(%edi)	/* jmp_buf [0].edi = eax (pushed edi) */

	movl	0(%ebp),%eax	/* eax = pushed ebp */
	movl	%eax,24(%edi)	/* jmp_buf [0].ebp = eax (pushed ebp) */

	movl	%esp,%eax	/* eax = esp */
	addl	$12,%eax	/* eax = eax + 12 (edi+ebp+ret addr) */
	movl	%eax,28(%edi)	/* jmp_buf [0].esp = old esp */
	
	movl	4(%ebp),%eax	/* eax = ret addr */
	movl	%eax,32(%edi)	/* jmp_buf [0].eip = ret addr */

	popl	%edi		/* pop edi */
	movl	$0,%eax		/* return 0 */
	leave
	ret
