/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <sys/syscalls.h>
#include <sys/message.h>
#include <sys/time.h>

int _gettimeofday (struct timeval * tv, struct timezone * tz)
  {
    MESSAGE mess;
    mess.type = m_gettimeofday;
    mess.m.gettimeofday_m.timeval  = (word32) tv;
    mess.m.gettimeofday_m.timezone = (word32) tz;
    return call_system (&mess);
  }

int _settimeofday (struct timeval * tv, struct timezone * tz)
  {
    MESSAGE mess;
    mess.type = m_settimeofday;
    mess.m.settimeofday_m.timeval  = (word32) tv;
    mess.m.settimeofday_m.timezone = (word32) tz;
    return call_system (&mess);
  }
