/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <stdlib.h>
#include "/ex32/include/graphics.h"
#include "/ex32/include/sys/GrMess.h"

static struct palettetype local_palette;
static char local_drivername [GR_STRLEN];
static char local_modename [GR_STRLEN];
static char local_errormsg [GR_STRLEN];

void arc (int x, int y, int stangle, int endangle, int radius)
  {
    Graphic_Mess mess;
    mess.arc_m.x = x;
    mess.arc_m.y = y;
    mess.arc_m.stangle = stangle;
    mess.arc_m.endangle = endangle;
    mess.arc_m.radius = radius;
    send_grmess (m_arc, &mess);
  }

void bar (int left, int top, int right, int bottom)
  {
    Graphic_Mess mess;
    mess.bar_m.left = left;
    mess.bar_m.top = top;
    mess.bar_m.right = right;
    mess.bar_m.bottom = bottom;
    send_grmess (m_bar, &mess);
  }

void bar3d (int left, int top, int right, int bottom, int depth, int topflag)
  {
    Graphic_Mess mess;
    mess.bar3d_m.left = left;
    mess.bar3d_m.top = top;
    mess.bar3d_m.right = right;
    mess.bar3d_m.bottom = bottom;
    mess.bar3d_m.depth = depth;
    mess.bar3d_m.topflag = topflag;
    send_grmess (m_bar3d, &mess);
  }

void circle (int x, int y, int radius)
  {
    Graphic_Mess mess;
    mess.circle_m.x = x;
    mess.circle_m.y = y;
    mess.circle_m.radius = radius;
    send_grmess (m_circle, &mess);
  }

void cleardevice (void)
  {
    Graphic_Mess mess;
    send_grmess (m_cleardevice, &mess);
  }

void clearviewport (void)
  {
    Graphic_Mess mess;
    send_grmess (m_clearviewport, &mess);
  }

void closegraph (void)
  {
    Graphic_Mess mess;
    send_grmess (m_closegraph, &mess);
  }

void detectgraph (int * graphdriver, int * graphmode)
  {
    Graphic_Mess mess;
    recv_grmess (m_detectgraph, &mess);
    *graphdriver = mess.detectgraph_m.graphdriver;
    *graphmode = mess.detectgraph_m.graphmode;
  }

void drawpoly (int numpoints, int * polypoints)
  {
    Graphic_Mess mess; int i;
    if (numpoints < GR_POLYCOORD) {
      mess.drawpoly_m.numpoints = numpoints;
      for (i = 0; i < 2 * numpoints; i++) {
	mess.drawpoly_m.polypoints [i] = polypoints [i];
      }
      send_grmess (m_drawpoly, &mess);
    }
  }

void ellipse (int x, int y, int stangle, int endangle, int xradius, int yradius)
  {
    Graphic_Mess mess;
    mess.ellipse_m.x = x;
    mess.ellipse_m.y = y;
    mess.ellipse_m.stangle = stangle;
    mess.ellipse_m.endangle = endangle;
    mess.ellipse_m.xradius = xradius;
    mess.ellipse_m.yradius = yradius;
    send_grmess (m_ellipse, &mess);
  }

void fillellipse (int x, int y, int xradius, int yradius)
  {
    Graphic_Mess mess;
    mess.fillellipse_m.x = x;
    mess.fillellipse_m.y = y;
    mess.fillellipse_m.xradius = xradius;
    mess.fillellipse_m.yradius = yradius;
    send_grmess (m_fillellipse, &mess);
  }

void fillpoly (int numpoints, int * polypoints)
  {
    Graphic_Mess mess; int i;
    if (numpoints < GR_POLYSIZE) {
      mess.fillpoly_m.numpoints = numpoints;
      for (i = 0; i < 2 * numpoints; i++) {
	mess.fillpoly_m.polypoints [i] = polypoints [i];
      }
      send_grmess (m_fillpoly, &mess);
    }
  }

void floodfill (int x, int y, int border)
  {
    Graphic_Mess mess;
    mess.floodfill_m.x = x;
    mess.floodfill_m.y = y;
    mess.floodfill_m.border = border;
    send_grmess (m_floodfill, &mess);
  }

void getarccoords (struct arccoordstype * arccoords)
  {
    Graphic_Mess mess;
    recv_grmess (m_getarccoords, &mess);
    arccoords->x = mess.getarccoords_m.arccoords.x;
    arccoords->y = mess.getarccoords_m.arccoords.y;
    arccoords->xstart = mess.getarccoords_m.arccoords.xstart;
    arccoords->ystart = mess.getarccoords_m.arccoords.ystart;
    arccoords->xend = mess.getarccoords_m.arccoords.xend;
    arccoords->yend = mess.getarccoords_m.arccoords.yend;
  }

void getaspectratio (int * xasp, int * yasp)
  {
    Graphic_Mess mess;
    recv_grmess (m_getaspectratio, &mess);
    *xasp = mess.getaspectratio_m.xasp;
    *yasp = mess.getaspectratio_m.yasp;
  }

int getbkcolor (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getbkcolor, &mess);
    return mess.gresult_m.result;
  }

int getcolor (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getcolor, &mess);
    return mess.gresult_m.result;
  }

struct palettetype * getdefaultpalette (void)
  {
    Graphic_Mess mess; int i;
    recv_grmess (m_getdefaultpalette, &mess);
    local_palette.size = mess.getdefaultpalette_m.palette.size;
    for (i = 0; i < MAXCOLORS+1; i++) {
      local_palette.colors [i] = mess.getdefaultpalette_m.palette.colors [i];
    }
    return &local_palette;
  }

char * getdrivername (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getdrivername, &mess);
    strcpy (local_drivername, mess.getdrivername_m.drivername);
    return local_drivername;
  }

void getfillpattern (char * pattern)
  {
    Graphic_Mess mess; int i;
    recv_grmess (m_getfillpattern, &mess);
    for (i = 0; i < GR_FILLPATTERN; i++) {
      pattern [i] = mess.getfillpattern_m.pattern [i];
    }
  }

void getfillsettings (struct fillsettingstype * fillinfo)
  {
    Graphic_Mess mess;
    recv_grmess (m_getfillsettings, &mess);
    fillinfo->pattern = mess.getfillsettings_m.fillinfo.pattern;
    fillinfo->color = mess.getfillsettings_m.fillinfo.color;
  }

int getgraphmode (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getgraphmode, &mess);
    return mess.gresult_m.result;
  }

void getimage (int left, int top, int right, int bottom, void * bitmap)
  {
    Graphic_Mess mess; int size, i; char * ptr; unsigned * iptr;
    size = imagesize (left, top, right, bottom);
    if (size < GR_BITMAPSIZE) {
      mess.getimage_m.left = left;
      mess.getimage_m.top = top;
      mess.getimage_m.right = right;
      mess.getimage_m.bottom = bottom;
      sendrecv_grmess (m_getimage, &mess);
      ptr  = (char *) bitmap;
      iptr = (unsigned *) bitmap;
      *iptr = size;			/* save size in bitmap for putimage */ 
      for (i = 0; i < size; i++) {
	ptr [i+4] = mess.getimage_m.bitmap [i];
      }
    }
  }

void getlinesettings (struct linesettingstype * lineinfo)
  {
    Graphic_Mess mess;
    recv_grmess (m_getlinesettings, &mess);
    lineinfo->linestyle = mess.getlinesettings_m.lineinfo.linestyle;
    lineinfo->upattern = mess.getlinesettings_m.lineinfo.upattern;
    lineinfo->thickness = mess.getlinesettings_m.lineinfo.thickness;
  }

int getmaxcolor (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getmaxcolor, &mess);
    return mess.gresult_m.result;
  }

int getmaxmode (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getmaxmode, &mess);
    return mess.gresult_m.result;
  }

int getmaxx (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getmaxx, &mess);
    return mess.gresult_m.result;
  }

int getmaxy (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getmaxy, &mess);
    return mess.gresult_m.result;
  }

char * getmodename (int mode_number)
  {
    Graphic_Mess mess;
    mess.getmodename_m.mode_number = mode_number;
    sendrecv_grmess (m_getmodename, &mess);
    strcpy (local_modename, mess.getmodename_m.mode_name);
    return local_modename;
  }

void getmoderange (int graphdriver, int * lomode, int * himode)
  {
    Graphic_Mess mess;
    mess.getmoderange_m.graphdriver = graphdriver;
    sendrecv_grmess (m_getmoderange, &mess);
    *lomode = mess.getmoderange_m.lomode;
    *himode = mess.getmoderange_m.himode;
  }

void getpalette (struct palettetype * palette)
  {
    Graphic_Mess mess; int i;
    recv_grmess (m_getpalette, &mess);
    palette->size = mess.getpalette_m.palette.size;
    for (i = 0; i < MAXCOLORS+1; i++) {
      palette->colors [i] = mess.getpalette_m.palette.colors [i];
    }
  }

int getpalettesize (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getpalettesize, &mess);
    return mess.gresult_m.result;
  }

unsigned getpixel (int x, int y)
  {
    Graphic_Mess mess;
    mess.getpixel_m.x = x;
    mess.getpixel_m.y = y;
    recv_grmess (m_getpixel, &mess);
    return mess.gresult_m.result;
  }

void gettextsettings (struct textsettingstype * texttypeinfo)
  {
    Graphic_Mess mess;
    recv_grmess (m_gettextsettings, &mess);
    texttypeinfo->font = mess.gettextsettings_m.texttypeinfo.font;
    texttypeinfo->direction = mess.gettextsettings_m.texttypeinfo.direction;
    texttypeinfo->charsize = mess.gettextsettings_m.texttypeinfo.charsize;
    texttypeinfo->horiz = mess.gettextsettings_m.texttypeinfo.horiz;
    texttypeinfo->vert = mess.gettextsettings_m.texttypeinfo.vert;
  }

void getviewsettings (struct viewporttype * viewport)
  {
    Graphic_Mess mess;
    recv_grmess (m_getviewsettings, &mess);
    viewport->left = mess.getviewsettings_m.viewport.left;
    viewport->top = mess.getviewsettings_m.viewport.top;
    viewport->right = mess.getviewsettings_m.viewport.right;
    viewport->bottom = mess.getviewsettings_m.viewport.bottom;
    viewport->clip = mess.getviewsettings_m.viewport.clip;
  }

int getx (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_getx, &mess);
    return mess.gresult_m.result;
  }

int gety (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_gety, &mess);
    return mess.gresult_m.result;
  }

void graphdefaults (void)
  {
    Graphic_Mess mess;
    send_grmess (m_graphdefaults, &mess);
  }

char * grapherrormsg (int errorcode)
  {
    Graphic_Mess mess;
    mess.grapherrormsg_m.errorcode = errorcode;
    sendrecv_grmess (m_grapherrormsg, &mess);
    strcpy (local_errormsg, mess.grapherrormsg_m.errormsg);
    return local_errormsg;
  }

int graphresult (void)
  {
    Graphic_Mess mess;
    recv_grmess (m_graphresult, &mess);
    return mess.gresult_m.result;
  }

unsigned imagesize (int left, int top, int right, int bottom)
  {
    Graphic_Mess mess;
    mess.imagesize_m.left = left;
    mess.imagesize_m.top = top;
    mess.imagesize_m.right = right;
    mess.imagesize_m.bottom = bottom;
    sendrecv_grmess (m_imagesize, &mess);
    return mess.gresult_m.result + 4;
  }

void initgraph (int * graphdriver, int * graphmode, char * pathtodriver)
  {
    Graphic_Mess mess;
    mess.initgraph_m.graphdriver = *graphdriver;
    mess.initgraph_m.graphmode   = *graphmode;
    strcpy (mess.initgraph_m.pathtodriver, pathtodriver);
    sendrecv_grmess (m_initgraph, &mess);
    *graphdriver = mess.initgraph_m.graphdriver;
    *graphmode   = mess.initgraph_m.graphmode;
  }

void line (int x1, int y1, int x2, int y2)
  {
    Graphic_Mess mess;
    mess.line_m.x1 = x1;
    mess.line_m.y1 = y1;
    mess.line_m.x2 = x2;
    mess.line_m.y2 = y2;
    send_grmess (m_line, &mess);
  }

void linerel (int dx, int dy)
  {
    Graphic_Mess mess;
    mess.linerel_m.dx = dx;
    mess.linerel_m.dy = dy;
    send_grmess (m_linerel, &mess);
  }

void lineto (int x, int y)
  {
    Graphic_Mess mess;
    mess.lineto_m.x = x;
    mess.lineto_m.y = y;
    send_grmess (m_lineto, &mess);
  }

void moverel (int dx, int dy)
  {
    Graphic_Mess mess;
    mess.moverel_m.dx = dx;
    mess.moverel_m.dy = dy;
    send_grmess (m_moverel, &mess);
  }

void moveto (int x, int y)
  {
    Graphic_Mess mess;
    mess.moveto_m.x = x;
    mess.moveto_m.y = y;
    send_grmess (m_moveto, &mess);
  }

void outtext (char * textstring)
  {
    Graphic_Mess mess;
    if (strlen (textstring) < GR_STRLEN) {
      strcpy (mess.outtext_m.textstring, textstring);
      send_grmess (m_outtext, &mess);
    }
  }

void outtextxy (int x, int y, char * textstring)
  {
    Graphic_Mess mess;
    if (strlen (textstring) < GR_STRLEN) {
      mess.outtextxy_m.x = x;
      mess.outtextxy_m.y = y;
      strcpy (mess.outtextxy_m.textstring, textstring);
      send_grmess (m_outtextxy, &mess);
    }
  }

void pieslice (int x, int y, int stangle, int endangle, int radius)
  {
    Graphic_Mess mess;
    mess.pieslice_m.x = x;
    mess.pieslice_m.y = y;
    mess.pieslice_m.stangle = stangle;
    mess.pieslice_m.endangle = endangle;
    mess.pieslice_m.radius = radius;
    send_grmess (m_pieslice, &mess);
  }

void putimage (int left, int top, void * bitmap, int op)
  {
    Graphic_Mess mess; int i; char * ptr; unsigned * iptr;
    mess.putimage_m.left = left;
    mess.putimage_m.top  = top;
    ptr  = (char *) bitmap;
    iptr = (unsigned *) bitmap;
    if (*iptr >= GR_BITMAPSIZE) {
      return;
    }
    for (i = 0; i < *iptr; i++) {
      mess.putimage_m.bitmap [i] = ptr [i+4];
    }
    mess.putimage_m.op   = op;
    send_grmess (m_putimage, &mess);
  }

void putpixel (int x, int y, int color)
  {
    Graphic_Mess mess;
    mess.putpixel_m.x = x;
    mess.putpixel_m.y = y;
    mess.putpixel_m.color = color;
    send_grmess (m_putpixel, &mess);
  }

void rectangle (int left, int top, int right, int bottom)
  {
    Graphic_Mess mess;
    mess.rectangle_m.left = left;
    mess.rectangle_m.top = top;
    mess.rectangle_m.right = right;
    mess.rectangle_m.bottom = bottom;
    send_grmess (m_rectangle, &mess);
  }

void restorecrtmode (void)
  {
    Graphic_Mess mess;
    send_grmess (m_restorecrtmode, &mess);
  }

void sector (int x, int y, int stangle, int endangle, int xradius, int yradius)
  {
    Graphic_Mess mess;
    mess.sector_m.x = x;
    mess.sector_m.y = y;
    mess.sector_m.stangle = stangle;
    mess.sector_m.endangle = endangle;
    mess.sector_m.xradius = xradius;
    mess.sector_m.yradius = yradius;
    send_grmess (m_sector, &mess);
  }

void setactivepage (int page)
  {
    Graphic_Mess mess;
    mess.setactivepage_m.page = page;
    send_grmess (m_setactivepage, &mess);
  }

void setallpalette (struct palettetype * palette)
  {
    Graphic_Mess mess; int i;
    mess.setallpalette_m.palette.size = palette->size;
    for (i = 0; i < MAXCOLORS+1; i++) {
      mess.setallpalette_m.palette.colors [i] = palette->colors [i];
    }
    send_grmess (m_setallpalette, &mess);
  }

void setaspectratio (int xasp, int yasp)
  {
    Graphic_Mess mess;
    mess.setaspectratio_m.xasp = xasp;
    mess.setaspectratio_m.yasp = yasp;
    send_grmess (m_setaspectratio, &mess);
  }

void setbkcolor (int color)
  {
    Graphic_Mess mess;
    mess.setbkcolor_m.color = color;
    send_grmess (m_setbkcolor, &mess);
  }

void setcolor (int color)
  {
    Graphic_Mess mess;
    mess.setcolor_m.color = color;
    send_grmess (m_setcolor, &mess);
  }

void setfillpattern (char * upattern, int color)
  {
    Graphic_Mess mess; int i;
    for (i = 0; i < GR_FILLPATTERN; i++) {
      mess.setfillpattern_m.upattern [i] = upattern [i];
    }
    mess.setfillpattern_m.color = color;
    send_grmess (m_setfillpattern, &mess);
  }

void setfillstyle (int pattern, int color)
  {
    Graphic_Mess mess;
    mess.setfillstyle_m.pattern = pattern;
    mess.setfillstyle_m.color = color;
    send_grmess (m_setfillstyle, &mess);
  }

void setgraphmode (int mode)
  {
    Graphic_Mess mess;
    mess.setgraphmode_m.mode = mode;
    send_grmess (m_setgraphmode, &mess);
  }

void setlinestyle (int linestyle, unsigned upattern, int thickness)
  {
    Graphic_Mess mess;
    mess.setlinestyle_m.linestyle = linestyle;
    mess.setlinestyle_m.upattern = upattern;
    mess.setlinestyle_m.thickness = thickness;
    send_grmess (m_setlinestyle, &mess);
  }

void setpalette (int colornum, int color)
  {
    Graphic_Mess mess;
    mess.setpalette_m.colornum = colornum;
    mess.setpalette_m.color = color;
    send_grmess (m_setpalette, &mess);
  }

void setrgbpalette (int colornum, int red, int green, int blue)
  {
    Graphic_Mess mess;
    mess.setrgbpalette_m.colornum = colornum;
    mess.setrgbpalette_m.red = red;
    mess.setrgbpalette_m.green = green;
    mess.setrgbpalette_m.blue = blue;
    send_grmess (m_setrgbpalette, &mess);
  }

void settextjustify (int horiz, int vert)
  {
    Graphic_Mess mess;
    mess.settextjustify_m.horiz = horiz;
    mess.settextjustify_m.vert = vert;
    send_grmess (m_settextjustify, &mess);
  }

void settextstyle (int font, int direction, int charsize)
  {
    Graphic_Mess mess;
    mess.settextstyle_m.font = font;
    mess.settextstyle_m.direction = direction;
    mess.settextstyle_m.charsize = charsize;
    send_grmess (m_settextstyle, &mess);
  }

void setusercharsize (int multx, int divx, int multy, int divy)
  {
    Graphic_Mess mess;
    mess.setusercharsize_m.multx = multx;
    mess.setusercharsize_m.divx = divx;
    mess.setusercharsize_m.multy = multy;
    mess.setusercharsize_m.divy = divy;
    send_grmess (m_setusercharsize, &mess);
  }

void setviewport (int left, int top, int right, int bottom, int clip)
  {
    Graphic_Mess mess;
    mess.setviewport_m.left = left;
    mess.setviewport_m.top = top;
    mess.setviewport_m.right = right;
    mess.setviewport_m.bottom = bottom;
    mess.setviewport_m.clip = clip;
    send_grmess (m_setviewport, &mess);
  }

void setvisualpage (int page)
  {
    Graphic_Mess mess;
    mess.setvisualpage_m.page = page;
    send_grmess (m_setvisualpage, &mess);
  }

void setwritemode (int mode)
  {
    Graphic_Mess mess;
    mess.setwritemode_m.mode = mode;
    send_grmess (m_setwritemode, &mess);
  }

int textheight (char * textstring)
  {
    Graphic_Mess mess;
    if (strlen (textstring) < GR_STRLEN) {
      strcpy (mess.textheight_m.textstring, textstring);
      sendrecv_grmess (m_textheight, &mess);
      return mess.gresult_m.result;
    }
    return 0;
  }

int textwidth (char * textstring)
  {
    Graphic_Mess mess;
    if (strlen (textstring) < GR_STRLEN) {
      strcpy (mess.textwidth_m.textstring, textstring);
      sendrecv_grmess (m_textwidth, &mess);
      return mess.gresult_m.result;
    }
    return 0;
  }
